/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.collections4.map.LazyMap;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.bcf.BCF;
import uniol.apt.analysis.bicf.BiCF;
import uniol.apt.analysis.bounded.Bounded;
import uniol.apt.analysis.cf.ConflictFree;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.fc.WeightedFreeChoice;
import uniol.apt.analysis.homogeneous.Homogeneous;
import uniol.apt.analysis.isomorphism.IsomorphismLogic;
import uniol.apt.analysis.language.LanguageEquivalence;
import uniol.apt.analysis.mf.MergeFree;
import uniol.apt.analysis.on.OutputNonBranching;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.analysis.separation.LargestK;
import uniol.apt.analysis.sideconditions.Pure;
import uniol.apt.analysis.synthesize.InvalidRegionException;
import uniol.apt.analysis.synthesize.LimitedUnfolding;
import uniol.apt.analysis.synthesize.MissingLocationException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.Synthesizer;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.EquivalenceRelation;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class SynthesizePN {
    private final TransitionSystem ts;
    private final RegionUtility utility;
    private final boolean onlyEventSeparation;
    private final Set<Region> regions;
    private final EquivalenceRelation<State> failedStateSeparationRelation = new EquivalenceRelation();
    private final Map<String, Set<State>> failedEventStateSeparationProblems = new HashMap<String, Set<State>>();
    private final PNProperties properties;

    SynthesizePN(RegionUtility utility, PNProperties properties, boolean onlyEventSeparation, String stateMappingExtension, boolean quickFail, Set<Region> extraRegions) throws MissingLocationException {
        this.ts = utility.getTransitionSystem();
        this.utility = utility;
        this.onlyEventSeparation = onlyEventSeparation;
        this.properties = properties;
        this.regions = new HashSet<Region>(extraRegions);
        DebugUtil.debug((Object)"Input regions: ", this.regions);
        Synthesizer synthesizer = SeparationUtility.createSynthesizerInstance(utility, properties, onlyEventSeparation, quickFail, this.regions);
        this.regions.addAll(synthesizer.getSeparatingRegions());
        for (Set<State> set : synthesizer.getUnsolvableStateSeparationProblems()) {
            Iterator<State> iter = set.iterator();
            if (!iter.hasNext()) continue;
            State first = this.mapState(stateMappingExtension, iter.next());
            while (iter.hasNext()) {
                State next = this.mapState(stateMappingExtension, iter.next());
                this.failedStateSeparationRelation.joinClasses(first, next);
            }
        }
        for (Map.Entry entry : synthesizer.getUnsolvableEventStateSeparationProblems().entrySet()) {
            Set states = (Set)entry.getValue();
            if (states.isEmpty()) continue;
            HashSet<State> mappedStates = new HashSet<State>();
            for (State state : states) {
                mappedStates.add(this.mapState(stateMappingExtension, state));
            }
            this.failedEventStateSeparationProblems.put((String)entry.getKey(), (Set<State>)mappedStates);
        }
    }

    private State mapState(String stateMappingExtension, State state) {
        if (stateMappingExtension == null) {
            return state;
        }
        return (State)state.getExtension(stateMappingExtension);
    }

    public static Set<State> calculateUnseparatedStates(Set<State> states, Set<Region> regions) {
        HashSet<State> result = new HashSet<State>();
        HashSet<HashSet<State>> partition = new HashSet<HashSet<State>>();
        partition.add(new HashSet<State>(states));
        DebugUtil.debug("Calculating unseparated states");
        for (Region region : regions) {
            int discarded = 0;
            HashSet newPartition = new HashSet();
            for (Set set : partition) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                LazyMap markings = LazyMap.lazyMap(new HashMap(), FactoryUtils.prototypeFactory(new HashSet()));
                for (State state : set) {
                    try {
                        ((Set)markings.get(region.getMarkingForState(state))).add(state);
                    }
                    catch (UnreachableException e) {
                        return states;
                    }
                }
                for (Map.Entry entry : markings.entrySet()) {
                    if (((Set)entry.getValue()).size() > 1) {
                        newPartition.add(entry.getValue());
                        continue;
                    }
                    ++discarded;
                }
            }
            partition = newPartition;
            DebugUtil.debugFormat("After region %s, still have %d families (%d resulting singular families discarded)", region, partition.size(), discarded);
            if (!partition.isEmpty()) continue;
            break;
        }
        for (Set set : partition) {
            result.addAll(set);
        }
        return result;
    }

    private static void calculateRequiredRegionsAndProblems(TransitionSystem ts, Set<Set<Region>> separationProblems, Set<Region> requiredRegions, Set<Region> remainingRegions, boolean onlyEventSeparation) {
        State state;
        block0: for (Pair<State, String> problem : new EventStateSeparationProblems(ts)) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            state = problem.getFirst();
            String event = problem.getSecond();
            for (Region region : requiredRegions) {
                if (!SeparationUtility.isSeparatingRegion(region, state, event)) continue;
                continue block0;
            }
            HashSet<Region> sep = new HashSet<Region>();
            for (Region region : remainingRegions) {
                if (!SeparationUtility.isSeparatingRegion(region, state, event)) continue;
                sep.add(region);
            }
            if (sep.size() == 1) {
                Region region = (Region)sep.iterator().next();
                requiredRegions.add(region);
                remainingRegions.remove(region);
                continue;
            }
            if (sep.isEmpty()) continue;
            separationProblems.add(sep);
        }
        if (onlyEventSeparation) {
            return;
        }
        HashSet<State> remainingStates = new HashSet<State>(SynthesizePN.calculateUnseparatedStates(ts.getNodes(), requiredRegions));
        Iterator iterator = remainingStates.iterator();
        while (iterator.hasNext()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            state = (State)iterator.next();
            iterator.remove();
            block4: for (State otherState : remainingStates) {
                for (Region region : requiredRegions) {
                    if (!SeparationUtility.isSeparatingRegion(region, state, otherState)) continue;
                    continue block4;
                }
                HashSet<Region> hashSet = new HashSet<Region>();
                for (Region r4 : remainingRegions) {
                    if (!SeparationUtility.isSeparatingRegion(r4, state, otherState)) continue;
                    hashSet.add(r4);
                }
                if (hashSet.size() == 1) {
                    Region region = (Region)hashSet.iterator().next();
                    requiredRegions.add(region);
                    remainingRegions.remove(region);
                    continue;
                }
                if (hashSet.isEmpty()) continue;
                separationProblems.add(hashSet);
            }
        }
    }

    public static void minimizeRegions(TransitionSystem ts, Set<Region> requiredRegions, boolean onlyEventSeparation) {
        int numInputRegions = requiredRegions.size();
        HashSet<Region> remainingRegions = new HashSet<Region>(requiredRegions);
        requiredRegions.clear();
        HashSet<Set<Region>> separationProblems = new HashSet<Set<Region>>();
        SynthesizePN.calculateRequiredRegionsAndProblems(ts, separationProblems, requiredRegions, remainingRegions, onlyEventSeparation);
        DebugUtil.debug("Required regions after first pass:");
        DebugUtil.debug(requiredRegions);
        DebugUtil.debug("List of regions that solve each remaining separation problem:");
        DebugUtil.debug(separationProblems);
        for (Set set : separationProblems) {
            if (!Collections.disjoint(requiredRegions, set)) continue;
            requiredRegions.add((Region)set.iterator().next());
        }
        DebugUtil.debug("List of required regions:");
        DebugUtil.debug(requiredRegions);
        DebugUtil.debugFormat("Picked %d required regions out of %d input regions", requiredRegions.size(), numInputRegions);
    }

    public Set<Region> getSeparatingRegions() {
        return Collections.unmodifiableSet(this.regions);
    }

    public boolean wasSuccessfullySeparated() {
        return this.failedStateSeparationRelation.isEmpty() && this.failedEventStateSeparationProblems.isEmpty();
    }

    public Collection<Set<State>> getFailedStateSeparationProblems() {
        return Collections.unmodifiableCollection(this.failedStateSeparationRelation);
    }

    public Map<String, Set<State>> getFailedEventStateSeparationProblems() {
        return Collections.unmodifiableMap(this.failedEventStateSeparationProblems);
    }

    public RegionUtility getUtility() {
        return this.utility;
    }

    public PNProperties getProperties() {
        return this.properties;
    }

    public boolean onlyEventSeparation() {
        return this.onlyEventSeparation;
    }

    public static boolean isDistributedImplementation(RegionUtility utility, PNProperties properties, PetriNet pn) {
        String[] locationMap;
        try {
            locationMap = SeparationUtility.getLocationMap(utility, properties);
        }
        catch (MissingLocationException e) {
            DebugUtil.debug("Couldn't get location map");
            return false;
        }
        for (Place p : pn.getPlaces()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            String location = null;
            DebugUtil.debug((Object)"Examining preset of place ", (Object)p, (Object)" for obeying the required distribution");
            for (Transition t : p.getPostset()) {
                int event = utility.getEventIndex(t.getLabel());
                if (locationMap[event] == null) continue;
                if (location == null) {
                    location = locationMap[event];
                    DebugUtil.debug((Object)"Transition ", (Object)t, (Object)" sets location to ", (Object)location);
                    continue;
                }
                if (location.equals(locationMap[event])) continue;
                DebugUtil.debug((Object)"Transition ", (Object)t, (Object)" would set location to ", (Object)locationMap[event], (Object)", but this conflicts with earlier location");
                DebugUtil.debug("PN is not a distributed implementation!");
                return false;
            }
        }
        return true;
    }

    public static boolean isGeneralizedTNet(PetriNet pn) {
        for (Place place : pn.getPlaces()) {
            if (place.getPreset().size() > 1) {
                DebugUtil.debug((Object)"T-Net check: There is a merge at ", (Object)place.getId());
                return false;
            }
            if (place.getPostset().size() <= 1) continue;
            DebugUtil.debug((Object)"T-Net check: There is a conflict at ", (Object)place.getId());
            return false;
        }
        return true;
    }

    public static boolean isGeneralizedMarkedGraph(PetriNet pn) {
        for (Place place : pn.getPlaces()) {
            if (place.getPreset().size() != 1) {
                DebugUtil.debug((Object)"marked graph check: Preset of ", (Object)place.getId(), (Object)" doesn't have exactly one entry");
                return false;
            }
            if (place.getPostset().size() == 1) continue;
            DebugUtil.debug((Object)"marked graph check: Postset of ", (Object)place.getId(), (Object)" doesn't have exactly one entry");
            return false;
        }
        return true;
    }

    private static boolean regionsAreValid(Collection<Region> regions) {
        for (Region region : regions) {
            try {
                region.checkValidRegion();
            }
            catch (InvalidRegionException e) {
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    public PetriNet synthesizePetriNet() {
        if (!this.wasSuccessfullySeparated()) {
            return null;
        }
        return this.synthesizePetriNet(this.regions);
    }

    public PetriNet synthesizePetriNet(Set<Region> regions) {
        PetriNet pn;
        block22: {
            block21: {
                pn = SynthesizePN.synthesizePetriNet(this.utility, regions);
                assert (SynthesizePN.regionsAreValid(regions));
                assert (!this.properties.isPure() || Pure.checkPure(pn)) : regions;
                assert (!this.properties.isPlain() || new Plain().checkPlain(pn)) : regions;
                assert (!this.properties.isTNet() || SynthesizePN.isGeneralizedTNet(pn)) : regions;
                assert (!this.properties.isMarkedGraph() || SynthesizePN.isGeneralizedMarkedGraph(pn)) : regions;
                assert (!this.properties.isKBounded() || Bounded.checkBounded((PetriNet)pn).k <= (long)this.properties.getKForKBounded()) : regions;
                assert (!this.properties.isOutputNonbranching() || new OutputNonBranching(pn).check()) : regions;
                assert (!this.properties.isMergeFree() || new MergeFree().check(pn)) : regions;
                try {
                    assert (!this.properties.isConflictFree() || new ConflictFree(pn).check()) : regions;
                }
                catch (PreconditionFailedException e) {
                    if ($assertionsDisabled) break block21;
                    throw new AssertionError(regions);
                }
            }
            assert (!this.properties.isHomogeneous() || new Homogeneous().check(pn) == null) : regions;
            assert (!this.properties.isEqualConflict() || new Homogeneous().check(pn) == null) : regions;
            assert (!this.properties.isEqualConflict() || new WeightedFreeChoice().check(pn)) : regions;
            try {
                assert (!this.properties.isBehaviourallyConflictFree() || new BCF().check(pn) == null) : regions;
                assert (!this.properties.isBinaryConflictFree() || new BiCF().check(pn) == null) : regions;
                if (!this.onlyEventSeparation ? !$assertionsDisabled && !new IsomorphismLogic(CoverabilityGraph.get(pn).toReachabilityLTS(), this.ts, true).isIsomorphic() : !$assertionsDisabled && LanguageEquivalence.checkLanguageEquivalence(CoverabilityGraph.get(pn).toReachabilityLTS(), this.ts) != null) {
                    throw new AssertionError(regions);
                }
            }
            catch (UnboundedException e) {
                if ($assertionsDisabled) break block22;
                throw new AssertionError(regions);
            }
        }
        assert (SynthesizePN.isDistributedImplementation(this.utility, this.properties, pn)) : regions;
        assert (new LargestK(pn).computeLargestK() % (long)this.properties.getKForKMarking() == 0L) : this.properties.getKForKMarking() + "-marking: " + regions;
        return pn;
    }

    public static PetriNet synthesizePetriNet(RegionUtility utility, Set<Region> regions) {
        PetriNet pn = new PetriNet();
        DebugUtil.debug("Synthesizing PetriNet from these regions:");
        DebugUtil.debug(regions);
        for (String event : utility.getEventList()) {
            pn.createTransition(event);
        }
        for (Region region : regions) {
            Place place = pn.createPlace();
            place.setInitialToken(SynthesizePN.bigIntToLong(region.getInitialMarking()));
            place.putExtension(Region.class.getName(), region);
            for (String event : region.getRegionUtility().getEventList()) {
                Transition transition = pn.getTransition(event);
                int backward = SynthesizePN.bigIntToInt(region.getBackwardWeight(event));
                assert (backward >= 0);
                if (backward > 0) {
                    pn.createFlow(place, transition, backward);
                }
                int forward = SynthesizePN.bigIntToInt(region.getForwardWeight(event));
                assert (forward >= 0);
                if (forward <= 0) continue;
                pn.createFlow(transition, place, forward);
            }
        }
        return pn;
    }

    private static long bigIntToLong(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Cannot represent value as long: " + value);
        }
        return value.longValue();
    }

    private static int bigIntToInt(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Cannot represent value as int: " + value);
        }
        return value.intValue();
    }

    public static class EventStateSeparationProblems
    implements Iterable<Pair<State, String>> {
        private final TransitionSystem ts;

        public EventStateSeparationProblems(TransitionSystem ts) {
            this.ts = ts;
        }

        @Override
        public Iterator<Pair<State, String>> iterator() {
            return new Iterator<Pair<State, String>>(){
                private Iterator<State> states;
                private State currentState;
                private PeekingIterator<String> alphabet;
                {
                    this.states = EventStateSeparationProblems.this.ts.getNodes().iterator();
                    this.currentState = null;
                    this.alphabet = null;
                }

                @Override
                public boolean hasNext() {
                    while (true) {
                        if (this.alphabet == null || !this.alphabet.hasNext()) {
                            if (!this.states.hasNext()) {
                                return false;
                            }
                            this.currentState = this.states.next();
                            this.alphabet = PeekingIterator.peekingIterator(EventStateSeparationProblems.this.ts.getAlphabet().iterator());
                            continue;
                        }
                        if (!SeparationUtility.isEventEnabled(this.currentState, this.alphabet.peek())) {
                            return true;
                        }
                        this.alphabet.next();
                    }
                }

                @Override
                public Pair<State, String> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return new Pair<State, String>(this.currentState, this.alphabet.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class Builder {
        private RegionUtility utility;
        private PNProperties properties = new PNProperties();
        private boolean quickFail = false;
        private final Set<Region> extraRegions = new HashSet<Region>();
        private final boolean languageEquivalence;

        public static Builder createForIsomorphicBehaviour(RegionUtility utility) {
            return new Builder(utility, false);
        }

        public static Builder createForIsomorphicBehaviour(TransitionSystem ts) {
            return new Builder(ts, false);
        }

        public static Builder createForLanguageEquivalence(RegionUtility utility) {
            return new Builder(utility, true);
        }

        public static Builder createForLanguageEquivalence(TransitionSystem ts) throws NonDeterministicException {
            return new Builder(LimitedUnfolding.calculateLimitedUnfolding(ts), true);
        }

        private Builder(TransitionSystem ts, boolean languageEquivalence) {
            this(new RegionUtility(ts), languageEquivalence);
        }

        private Builder(RegionUtility utility, boolean languageEquivalence) {
            this.utility = utility;
            this.languageEquivalence = languageEquivalence;
        }

        public Builder setProperties(PNProperties props) {
            this.properties = props;
            return this;
        }

        public PNProperties getProperties() {
            return this.properties;
        }

        public RegionUtility getRegionUtility() {
            return this.utility;
        }

        public Builder setQuickFail(boolean qf) {
            this.quickFail = qf;
            return this;
        }

        public Builder addRegion(Region r) throws InvalidRegionException {
            if (!r.getRegionUtility().equals(this.utility)) {
                throw new IllegalArgumentException("The given region belongs to a different region utility");
            }
            r.checkValidRegion();
            this.extraRegions.add(r);
            return this;
        }

        public SynthesizePN build() throws MissingLocationException {
            if (this.languageEquivalence) {
                return new SynthesizePN(this.utility, this.properties, true, "ORIGINAL_STATE", this.quickFail, this.extraRegions);
            }
            return new SynthesizePN(this.utility, this.properties, false, null, this.quickFail, this.extraRegions);
        }
    }
}

