/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.AbstractSynthesizeModule;
import uniol.apt.analysis.synthesize.OverapproximatePN;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SynthesizeOverapproximateModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Synthesize the minimal Petri Net overapproximation from a transition system";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\n" + AbstractSynthesizeModule.getOptionsDescription("", "") + "\n\nExample calls:\n\n apt " + this.getName() + " none lts.apt\n apt " + this.getName() + " 3-bounded lts.apt\n apt " + this.getName() + " pure,safe lts.apt\n";
    }

    @Override
    public String getName() {
        return "overapproximate_synthesize";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("options", String.class, "Comma separated list of options", new String[0]);
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be synthesized to a Petri Net", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        String optionsStr = input.getParameter("options", String.class);
        AbstractSynthesizeModule.Options options = AbstractSynthesizeModule.Options.parseProperties(optionsStr);
        try {
            PetriNet pn = OverapproximatePN.overapproximate(ts, options.properties);
            output.setReturnValue("pn", PetriNet.class, pn);
        }
        catch (UnsupportedPNPropertiesException e) {
            throw new ModuleException(e);
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

