/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.AbstractSynthesizeModule;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SynthesizeModule
extends AbstractSynthesizeModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Synthesize a Petri Net from a transition system";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\n" + SynthesizeModule.getOptionsDescription("", "") + "\n\nExample calls:\n\n apt " + this.getName() + " none lts.apt\n apt " + this.getName() + " 3-bounded lts.apt\n apt " + this.getName() + " pure,safe lts.apt\n apt " + this.getName() + " upto-language-equivalence lts.apt\n";
    }

    @Override
    public String getName() {
        return "synthesize";
    }

    @Override
    protected void requireExtra(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be synthesized to a Petri Net", new String[0]);
    }

    @Override
    protected void provideExtra(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("failedStateSeparationProblems", String.class, new String[0]);
        outputSpec.addReturnValue("failedEventStateSeparationProblems", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        SynthesizePN synthesize = this.runSynthesis(new ReturnTS(ts), input, output);
        if (!synthesize.wasSuccessfullySeparated()) {
            HashSet failedSSP = new HashSet();
            for (Set<State> group : synthesize.getFailedStateSeparationProblems()) {
                TreeSet<String> states = new TreeSet<String>();
                for (State state : group) {
                    states.add(state.getId());
                }
                failedSSP.add(states);
            }
            output.setReturnValue("failedStateSeparationProblems", String.class, ((Object)failedSSP).toString());
            TreeMap<String, Set<String>> failedESSP = new TreeMap<String, Set<String>>();
            for (Map.Entry<String, Set<State>> entry : synthesize.getFailedEventStateSeparationProblems().entrySet()) {
                failedESSP.put(entry.getKey(), SynthesizeModule.getStateIDs(entry.getValue()));
            }
            output.setReturnValue("failedEventStateSeparationProblems", String.class, ((Object)failedESSP).toString());
        }
    }

    protected static class ReturnTS
    implements AbstractSynthesizeModule.TransitionSystemForOptions {
        private final TransitionSystem ts;

        public ReturnTS(TransitionSystem ts) {
            this.ts = ts;
        }

        @Override
        public Collection<String> supportedExtraOptions() {
            return Collections.emptyList();
        }

        @Override
        public TransitionSystem getTS(Collection<String> enabledOptions) {
            return this.ts;
        }
    }
}

