/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.AbstractSynthesizeModule;
import uniol.apt.analysis.synthesize.InvalidRegionException;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.SynthesizeModule;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.exception.ModuleException;

public class SynthesizeExtendModule
extends SynthesizeModule
implements Module {
    @Override
    public String getShortDescription() {
        return "Synthesize a Petri Net from a transition system, reusing places of a PetriNet";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". This module gets a PetriNet as input and tries to re-use the places of the given PetriNet in the synthesized result.";
    }

    @Override
    public String getName() {
        return "pn_extend_and_synthesize";
    }

    @Override
    protected void requireExtra(ModuleInputSpec inputSpec) {
        super.requireExtra(inputSpec);
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net whose places should be re-used", new String[0]);
    }

    private static BigInteger getArcWeight(Collection<Flow> flows, String event) {
        BigInteger result = BigInteger.ZERO;
        for (Flow flow : flows) {
            if (!flow.getTransition().getId().equals(event)) continue;
            result = result.add(BigInteger.valueOf(flow.getWeight()));
        }
        return result;
    }

    private static Region addWeightForEvent(Region region, String event) {
        for (Arc arc : region.getTransitionSystem().getEdges()) {
            if (!arc.getLabel().equals(event)) continue;
            try {
                BigInteger source = region.getMarkingForState((State)arc.getSource());
                BigInteger target = region.getMarkingForState((State)arc.getTarget());
                Region.Builder builder = new Region.Builder(region);
                builder.addWeightOn(event, target.subtract(source));
                return builder.withInitialMarking(region.getInitialMarking());
            }
            catch (UnreachableException unreachableException) {
            }
        }
        return region;
    }

    @Override
    public SynthesizePN runSynthesis(AbstractSynthesizeModule.TransitionSystemForOptions tsForOpts, ModuleInput input, ModuleOutput output) throws ModuleException {
        final PetriNet pn = input.getParameter("pn", PetriNet.class);
        AbstractSynthesizeModule.ConfigureSynthesizePNBuilder configure = new AbstractSynthesizeModule.ConfigureSynthesizePNBuilder(){

            @Override
            public void configureSynthesizePNBuilder(SynthesizePN.Builder builder) {
                RegionUtility utility = builder.getRegionUtility();
                TransitionSystem ts = utility.getTransitionSystem();
                HashSet<String> labelsMissingFromTS = new HashSet<String>();
                for (Transition transition : pn.getTransitions()) {
                    if (ts.getAlphabet().contains(transition.getId())) continue;
                    labelsMissingFromTS.add(transition.getId());
                }
                if (!labelsMissingFromTS.isEmpty()) {
                    System.err.println("Ignoring the following transitions, because no such event is present in the transition system: " + ((Object)labelsMissingFromTS).toString());
                }
                HashSet<String> labelsMissingFromPN = new HashSet<String>();
                for (String event : ts.getAlphabet()) {
                    if (pn.containsTransition(event)) continue;
                    labelsMissingFromPN.add(event);
                }
                if (!labelsMissingFromPN.isEmpty()) {
                    System.err.println("The following events are not present in the Petri net: " + ((Object)labelsMissingFromPN).toString());
                }
                for (Place p : pn.getPlaces()) {
                    ArrayList<BigInteger> backward = new ArrayList<BigInteger>();
                    ArrayList<BigInteger> forward = new ArrayList<BigInteger>();
                    for (String event : utility.getEventList()) {
                        backward.add(SynthesizeExtendModule.getArcWeight(p.getPostsetEdges(), event));
                        forward.add(SynthesizeExtendModule.getArcWeight(p.getPresetEdges(), event));
                    }
                    BigInteger marking = BigInteger.valueOf(p.getInitialToken().getValue());
                    Region region = new Region.Builder(utility, backward, forward).withInitialMarking(marking);
                    for (String event : labelsMissingFromPN) {
                        region = SynthesizeExtendModule.addWeightForEvent(region, event);
                    }
                    try {
                        builder.addRegion(region);
                    }
                    catch (InvalidRegionException e) {
                        System.err.println(String.format("Ignoring place %s, because it is not valid for the target transition system", p.getId()));
                    }
                }
            }
        };
        return this.runSynthesis(tsForOpts, configure, input, output);
    }
}

