/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.util.SpanningTree;
import uniol.apt.util.equations.EquationSystem;

public class RegionUtility {
    private final TransitionSystem ts;
    private final SpanningTree<TransitionSystem, Arc, State> tree;
    private final List<String> eventList;
    private final Map<State, List<BigInteger>> parikhVectorMap = new HashMap<State, List<BigInteger>>();
    private List<Region> regionBasis;

    public RegionUtility(SpanningTree<TransitionSystem, Arc, State> tree) {
        this.ts = tree.getGraph();
        this.tree = tree;
        this.eventList = Collections.unmodifiableList(new ArrayList<String>(this.ts.getAlphabet()));
        this.regionBasis = null;
    }

    public RegionUtility(TransitionSystem ts) {
        this(SpanningTree.get(ts, ts.getInitialState()));
    }

    public int getEventIndex(String event) {
        return this.eventList.indexOf(event);
    }

    public List<String> getEventList() {
        return this.eventList;
    }

    public int getNumberOfEvents() {
        return this.eventList.size();
    }

    public SpanningTree<TransitionSystem, Arc, State> getSpanningTree() {
        return this.tree;
    }

    public TransitionSystem getTransitionSystem() {
        return this.tree.getGraph();
    }

    public List<BigInteger> getReachingParikhVector(State node) throws UnreachableException {
        List<Object> result = this.parikhVectorMap.get(node);
        if (result == null) {
            if (node.equals(this.tree.getStartNode())) {
                Object[] array = new BigInteger[this.eventList.size()];
                Arrays.fill(array, BigInteger.ZERO);
                result = Arrays.asList(array);
            } else {
                Arc predecessor = this.tree.getPredecessorEdge(node);
                if (predecessor == null) {
                    throw new UnreachableException(this.ts, node);
                }
                List<BigInteger> predVector = this.getReachingParikhVector((State)predecessor.getSource());
                result = new ArrayList<BigInteger>();
                result.addAll(predVector);
                int idx = this.getEventIndex(predecessor.getLabel());
                result.set(idx, ((BigInteger)result.get(idx)).add(BigInteger.ONE));
            }
            result = Collections.unmodifiableList(result);
            this.parikhVectorMap.put(node, result);
        }
        return result;
    }

    public List<BigInteger> getParikhVectorForEdge(Arc edge) throws UnreachableException {
        State source = (State)edge.getSource();
        State target = (State)edge.getTarget();
        List<BigInteger> sourcePV = this.getReachingParikhVector(source);
        List<BigInteger> targetPV = this.getReachingParikhVector(target);
        int eventIndex = this.getEventIndex(edge.getLabel());
        if (sourcePV.isEmpty() || targetPV.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BigInteger> result = new ArrayList<BigInteger>(this.eventList.size());
        for (int i = 0; i < this.eventList.size(); ++i) {
            BigInteger sourceVal = sourcePV.get(i);
            BigInteger targetVal = targetPV.get(i);
            BigInteger addend = i == eventIndex ? BigInteger.ONE : BigInteger.ZERO;
            result.add(sourceVal.subtract(targetVal).add(addend));
        }
        return Collections.unmodifiableList(result);
    }

    public List<Region> getRegionBasis() {
        if (this.regionBasis == null) {
            EquationSystem system = new EquationSystem(this.getNumberOfEvents());
            for (Arc chord : this.tree.getChords()) {
                try {
                    system.addEquation(this.getParikhVectorForEdge(chord));
                }
                catch (UnreachableException e) {
                    throw new AssertionError("A chord by definition belongs to reachable nodes, yet one of them was unreachable?", e);
                }
            }
            ArrayList<Region> result = new ArrayList<Region>();
            for (List<BigInteger> vector : system.findBasis()) {
                result.add(Region.Builder.createPure(this, vector).withNormalRegionInitialMarking());
            }
            this.regionBasis = Collections.unmodifiableList(result);
        }
        return this.regionBasis;
    }
}

