/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.InvalidRegionException;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.util.Pair;

public class Region {
    private final RegionUtility utility;
    private final List<BigInteger> backwardWeights;
    private final List<BigInteger> forwardWeights;
    private final BigInteger initialMarking;
    private final Map<State, BigInteger> stateMarkingCache = new HashMap<State, BigInteger>();

    private Region(RegionUtility utility, List<BigInteger> backwardWeights, List<BigInteger> forwardWeights, BigInteger initialMarking) {
        this.utility = utility;
        this.backwardWeights = Collections.unmodifiableList(new ArrayList<BigInteger>(backwardWeights));
        this.forwardWeights = Collections.unmodifiableList(new ArrayList<BigInteger>(forwardWeights));
        this.initialMarking = initialMarking;
        int numberEvents = utility.getNumberOfEvents();
        if (backwardWeights.size() != numberEvents) {
            throw new IllegalArgumentException("There must be as many backward weights as events");
        }
        if (forwardWeights.size() != numberEvents) {
            throw new IllegalArgumentException("There must be as many forward weights as events");
        }
        for (BigInteger i : backwardWeights) {
            if (i.compareTo(BigInteger.ZERO) >= 0) continue;
            throw new IllegalArgumentException("Backward weight i=" + i + " must not be negative");
        }
        for (BigInteger i : forwardWeights) {
            if (i.compareTo(BigInteger.ZERO) >= 0) continue;
            throw new IllegalArgumentException("Forward weight i=" + i + " must not be negative");
        }
        if (initialMarking.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Initial marking " + initialMarking + " must not be negative");
        }
    }

    public RegionUtility getRegionUtility() {
        return this.utility;
    }

    public TransitionSystem getTransitionSystem() {
        return this.utility.getTransitionSystem();
    }

    public BigInteger getBackwardWeight(int index) {
        return this.backwardWeights.get(index);
    }

    public BigInteger getBackwardWeight(String event) {
        return this.backwardWeights.get(this.utility.getEventIndex(event));
    }

    public BigInteger getForwardWeight(int index) {
        return this.forwardWeights.get(index);
    }

    public BigInteger getForwardWeight(String event) {
        return this.forwardWeights.get(this.utility.getEventIndex(event));
    }

    public BigInteger getWeight(int index) {
        return this.getForwardWeight(index).subtract(this.getBackwardWeight(index));
    }

    public BigInteger getWeight(String event) {
        return this.getWeight(this.utility.getEventIndex(event));
    }

    public BigInteger evaluateParikhVector(List<BigInteger> vector) {
        assert (vector.size() == this.utility.getEventList().size());
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < vector.size(); ++i) {
            result = result.add(vector.get(i).multiply(this.getWeight(i)));
        }
        return result;
    }

    public BigInteger getInitialMarking() {
        return this.initialMarking;
    }

    public BigInteger getMarkingForState(State state) throws UnreachableException {
        BigInteger i = this.stateMarkingCache.get(state);
        if (i == null) {
            i = this.getInitialMarking().add(this.evaluateParikhVector(this.utility.getReachingParikhVector(state)));
            this.stateMarkingCache.put(state, i);
        }
        return i;
    }

    public Pair<State, String> findPreventedArc() {
        for (State state : this.getTransitionSystem().getNodes()) {
            BigInteger marking;
            try {
                marking = this.getMarkingForState(state);
            }
            catch (UnreachableException e) {
                continue;
            }
            for (Arc arc : state.getPostsetEdges()) {
                BigInteger targetMarking = marking.subtract(this.getBackwardWeight(arc.getLabel()));
                if (targetMarking.compareTo(BigInteger.ZERO) >= 0) continue;
                return new Pair<State, String>(state, arc.getLabel());
            }
        }
        return null;
    }

    public Arc findArcWithWrongEffect() {
        for (Arc arc : this.getTransitionSystem().getEdges()) {
            try {
                BigInteger source = this.getMarkingForState((State)arc.getSource());
                BigInteger target = this.getMarkingForState((State)arc.getTarget());
                BigInteger effect = this.getWeight(arc.getLabel());
                if (source.add(effect).equals(target)) continue;
                return arc;
            }
            catch (UnreachableException e) {
            }
        }
        return null;
    }

    public void checkValidRegion() throws InvalidRegionException {
        Pair<State, String> counterexample = this.findPreventedArc();
        if (counterexample != null) {
            throw new InvalidRegionException(counterexample.getFirst(), counterexample.getSecond());
        }
        Arc counterexample2 = this.findArcWithWrongEffect();
        if (counterexample2 != null) {
            throw new InvalidRegionException(counterexample2);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{ init=");
        result.append(this.getInitialMarking());
        for (String event : this.utility.getEventList()) {
            result.append(", ");
            result.append(this.getBackwardWeight(event));
            result.append(":");
            result.append(event);
            result.append(":");
            result.append(this.getForwardWeight(event));
        }
        result.append(" }");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Region)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Region reg = (Region)obj;
        return reg.utility.equals(this.utility) && reg.forwardWeights.equals(this.forwardWeights) && reg.backwardWeights.equals(this.backwardWeights) && reg.getInitialMarking().equals(this.getInitialMarking());
    }

    public int hashCode() {
        return 31 * (this.forwardWeights.hashCode() + 31 * this.backwardWeights.hashCode()) + this.getInitialMarking().hashCode();
    }

    public static class Builder {
        private final RegionUtility utility;
        private final List<BigInteger> backwardList;
        private final List<BigInteger> forwardList;

        public Builder(RegionUtility utility, List<BigInteger> backward, List<BigInteger> forward) {
            if (backward.size() != utility.getNumberOfEvents()) {
                throw new IllegalArgumentException("The backward list must contain an entry per event");
            }
            if (forward.size() != utility.getNumberOfEvents()) {
                throw new IllegalArgumentException("The forward list must contain an entry per event");
            }
            this.utility = utility;
            this.backwardList = new ArrayList<BigInteger>(backward);
            this.forwardList = new ArrayList<BigInteger>(forward);
        }

        public Builder(RegionUtility utility) {
            this(utility, Collections.nCopies(utility.getNumberOfEvents(), BigInteger.ZERO), Collections.nCopies(utility.getNumberOfEvents(), BigInteger.ZERO));
        }

        public Builder(Region region) {
            this(region.utility, region.backwardWeights, region.forwardWeights);
        }

        public Builder addWeightOn(String event, BigInteger weight) {
            return this.addWeightOn(this.utility.getEventIndex(event), weight);
        }

        public Builder addWeightOn(int index, BigInteger weight) {
            int cmp = weight.compareTo(BigInteger.ZERO);
            if (cmp == 0) {
                return this;
            }
            if (cmp > 0) {
                this.forwardList.set(index, this.forwardList.get(index).add(weight));
            } else {
                this.backwardList.set(index, this.backwardList.get(index).subtract(weight));
            }
            return this;
        }

        public Builder addLoopAround(String event, BigInteger weight) {
            return this.addLoopAround(this.utility.getEventIndex(event), weight);
        }

        public Builder addLoopAround(int index, BigInteger weight) {
            this.backwardList.set(index, this.backwardList.get(index).add(weight));
            this.forwardList.set(index, this.forwardList.get(index).add(weight));
            return this;
        }

        public Builder addRegionWithFactor(Region region, BigInteger factor) {
            if (factor.equals(BigInteger.ZERO)) {
                return this;
            }
            List theirBackwardWeights = region.backwardWeights;
            List theirForwardWeights = region.forwardWeights;
            if (factor.compareTo(BigInteger.ZERO) < 0) {
                factor = factor.negate();
                List tmp = theirBackwardWeights;
                theirBackwardWeights = theirForwardWeights;
                theirForwardWeights = tmp;
            }
            for (int i = 0; i < this.utility.getNumberOfEvents(); ++i) {
                BigInteger weight = this.backwardList.get(i);
                this.backwardList.set(i, weight.add(factor.multiply((BigInteger)theirBackwardWeights.get(i))));
                weight = this.forwardList.get(i);
                this.forwardList.set(i, weight.add(factor.multiply((BigInteger)theirForwardWeights.get(i))));
            }
            return this;
        }

        public Builder makePure() {
            for (int i = 0; i < this.utility.getNumberOfEvents(); ++i) {
                BigInteger weight = this.forwardList.get(i).subtract(this.backwardList.get(i));
                if (weight.compareTo(BigInteger.ZERO) >= 0) {
                    this.forwardList.set(i, weight);
                    this.backwardList.set(i, BigInteger.ZERO);
                    continue;
                }
                this.forwardList.set(i, BigInteger.ZERO);
                this.backwardList.set(i, weight.negate());
            }
            return this;
        }

        public Region withInitialMarking(BigInteger initial) {
            return new Region(this.utility, this.backwardList, this.forwardList, initial);
        }

        public Region withNormalRegionInitialMarking() {
            int numEvents = this.utility.getNumberOfEvents();
            BigInteger initial = BigInteger.ZERO;
            for (State state : this.utility.getTransitionSystem().getNodes()) {
                try {
                    BigInteger value = BigInteger.ZERO;
                    List<BigInteger> pv = this.utility.getReachingParikhVector(state);
                    for (int i = 0; i < numEvents; ++i) {
                        value = value.add(pv.get(i).multiply(this.forwardList.get(i).subtract(this.backwardList.get(i))));
                    }
                    initial = initial.max(value.negate());
                }
                catch (UnreachableException e) {}
            }
            return this.withInitialMarking(initial);
        }

        public static Builder createPure(RegionUtility utility, List<BigInteger> vector) {
            if (vector.size() != utility.getNumberOfEvents()) {
                throw new IllegalArgumentException("The vector must contain one entry per event");
            }
            Builder result = new Builder(utility);
            for (int i = 0; i < vector.size(); ++i) {
                BigInteger value = vector.get(i);
                if (value.compareTo(BigInteger.ZERO) > 0) {
                    result.forwardList.set(i, value);
                    continue;
                }
                result.backwardList.set(i, value.negate());
            }
            return result;
        }

        public static Region copyRegionToUtility(RegionUtility utility, Region region) {
            if (utility.getEventList().equals(region.utility.getEventList())) {
                return new Region(utility, region.backwardWeights, region.forwardWeights, region.initialMarking);
            }
            Builder builder = new Builder(utility);
            List<String> regionEventList = region.utility.getEventList();
            for (int index = 0; index < regionEventList.size(); ++index) {
                int newIndex = utility.getEventIndex(regionEventList.get(index));
                if (newIndex < 0) {
                    throw new IllegalArgumentException("The given region utility does not have event '" + regionEventList.get(index) + "'");
                }
                builder.forwardList.set(newIndex, (BigInteger)region.forwardWeights.get(index));
                builder.backwardList.set(newIndex, (BigInteger)region.backwardWeights.get(index));
            }
            return builder.withInitialMarking(region.initialMarking);
        }
    }
}

