/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.ArrayList;
import java.util.Iterator;
import uniol.apt.util.MathTools;

public class PNProperties {
    private static final int KBOUNDED_DEFAULT = -1;
    private int kBounded = -1;
    private int kMarking = 1;
    private boolean pure = false;
    private boolean plain = false;
    private boolean tnet = false;
    private boolean markedgraph = false;
    private boolean outputNonbranching = false;
    private boolean mergeFree = false;
    private boolean conflictFree = false;
    private boolean homogeneous = false;
    private boolean behaviourallyConflictFree = false;
    private boolean binaryConflictFree = false;
    private boolean equalConflict = false;

    public PNProperties() {
    }

    private PNProperties(PNProperties other) {
        this.kBounded = other.kBounded;
        this.kMarking = other.kMarking;
        this.pure = other.pure;
        this.plain = other.plain;
        this.tnet = other.tnet;
        this.markedgraph = other.markedgraph;
        this.outputNonbranching = other.outputNonbranching;
        this.mergeFree = other.mergeFree;
        this.conflictFree = other.conflictFree;
        this.homogeneous = other.homogeneous;
        this.behaviourallyConflictFree = other.behaviourallyConflictFree;
        this.binaryConflictFree = other.binaryConflictFree;
        this.equalConflict = other.equalConflict;
    }

    public boolean isKBounded() {
        return this.kBounded != -1;
    }

    public boolean isKBounded(int k) {
        return this.isKBounded() && this.kBounded <= k;
    }

    public boolean isSafe() {
        return this.isKBounded(1);
    }

    public PNProperties requireSafe() {
        return this.requireKBounded(1);
    }

    public int getKForKBounded() {
        assert (this.isKBounded());
        return this.kBounded;
    }

    public PNProperties requireKBounded(int k) {
        assert (k >= 0);
        if (this.isKBounded(k)) {
            return this;
        }
        PNProperties result = new PNProperties(this);
        result.kBounded = k;
        return result;
    }

    public boolean isKMarking() {
        return this.kMarking != 1;
    }

    public int getKForKMarking() {
        return this.kMarking;
    }

    public PNProperties requireKMarking(int k) {
        assert (k >= 1);
        if (this.kMarking == k) {
            return this;
        }
        PNProperties result = new PNProperties(this);
        result.kMarking = MathTools.lcm(this.kMarking, k);
        return result;
    }

    public boolean isPure() {
        return this.pure;
    }

    public PNProperties setPure(boolean value) {
        PNProperties result = new PNProperties(this);
        result.pure = value;
        return result;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public PNProperties setPlain(boolean value) {
        PNProperties result = new PNProperties(this);
        result.plain = value;
        return result;
    }

    public boolean isTNet() {
        return this.tnet;
    }

    public PNProperties setTNet(boolean value) {
        PNProperties result = new PNProperties(this);
        result.tnet = value;
        return result;
    }

    public boolean isMarkedGraph() {
        return this.markedgraph;
    }

    public PNProperties setMarkedGraph(boolean value) {
        PNProperties result = new PNProperties(this);
        result.markedgraph = value;
        return result;
    }

    public boolean isOutputNonbranching() {
        return this.outputNonbranching;
    }

    public PNProperties setOutputNonbranching(boolean value) {
        PNProperties result = new PNProperties(this);
        result.outputNonbranching = value;
        return result;
    }

    public boolean isMergeFree() {
        return this.mergeFree;
    }

    public PNProperties setMergeFree(boolean value) {
        PNProperties result = new PNProperties(this);
        result.mergeFree = value;
        return result;
    }

    public boolean isConflictFree() {
        return this.conflictFree;
    }

    public PNProperties setConflictFree(boolean value) {
        PNProperties result = new PNProperties(this);
        result.conflictFree = value;
        return result;
    }

    public boolean isHomogeneous() {
        return this.homogeneous;
    }

    public PNProperties setHomogeneous(boolean value) {
        PNProperties result = new PNProperties(this);
        result.homogeneous = value;
        return result;
    }

    public boolean isBehaviourallyConflictFree() {
        return this.behaviourallyConflictFree;
    }

    public PNProperties setBehaviourallyConflictFree(boolean value) {
        PNProperties result = new PNProperties(this);
        result.behaviourallyConflictFree = value;
        return result;
    }

    public boolean isBinaryConflictFree() {
        return this.binaryConflictFree;
    }

    public PNProperties setBinaryConflictFree(boolean value) {
        PNProperties result = new PNProperties(this);
        result.binaryConflictFree = value;
        return result;
    }

    public boolean isEqualConflict() {
        return this.equalConflict;
    }

    public PNProperties setEqualConflict(boolean value) {
        PNProperties result = new PNProperties(this);
        result.equalConflict = value;
        return result;
    }

    public boolean containsAll(PNProperties other) {
        if (other.isKBounded() && (!this.isKBounded() || this.getKForKBounded() > other.getKForKBounded())) {
            return false;
        }
        if (other.isKMarking() && (!this.isKMarking() || this.getKForKMarking() % other.getKForKMarking() != 0)) {
            return false;
        }
        if (other.isPure() && !this.isPure()) {
            return false;
        }
        if (other.isPlain() && !this.isPlain()) {
            return false;
        }
        if (other.isTNet() && !this.isTNet()) {
            return false;
        }
        if (other.isMarkedGraph() && !this.isMarkedGraph()) {
            return false;
        }
        if (other.isOutputNonbranching() && !this.isOutputNonbranching()) {
            return false;
        }
        if (other.isMergeFree() && !this.isMergeFree()) {
            return false;
        }
        if (other.isConflictFree() && !this.isConflictFree()) {
            return false;
        }
        if (other.isHomogeneous() && !this.isHomogeneous()) {
            return false;
        }
        if (other.isBehaviourallyConflictFree() && !this.isBehaviourallyConflictFree()) {
            return false;
        }
        return !other.isBinaryConflictFree() || this.isBinaryConflictFree();
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.pure) {
            hashCode |= 1;
        }
        if (this.plain) {
            hashCode |= 2;
        }
        if (this.tnet) {
            hashCode |= 4;
        }
        if (this.markedgraph) {
            hashCode |= 8;
        }
        if (this.outputNonbranching) {
            hashCode |= 0x10;
        }
        if (this.mergeFree) {
            hashCode |= 0x20;
        }
        if (this.conflictFree) {
            hashCode |= 0x40;
        }
        if (this.homogeneous) {
            hashCode |= 0x80;
        }
        if (this.behaviourallyConflictFree) {
            hashCode |= 0x100;
        }
        if (this.binaryConflictFree) {
            hashCode |= 0x200;
        }
        if (this.equalConflict) {
            hashCode |= 0x400;
        }
        if (this.isKBounded()) {
            hashCode |= this.getKForKBounded() << 11;
        }
        if (this.isKMarking()) {
            hashCode ^= this.getKForKMarking() << 12;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PNProperties)) {
            return false;
        }
        PNProperties other = (PNProperties)o;
        if (this.kBounded != other.kBounded) {
            return false;
        }
        if (this.kMarking != other.kMarking) {
            return false;
        }
        if (this.pure != other.pure) {
            return false;
        }
        if (this.plain != other.plain) {
            return false;
        }
        if (this.tnet != other.tnet) {
            return false;
        }
        if (this.markedgraph != other.markedgraph) {
            return false;
        }
        if (this.outputNonbranching != other.outputNonbranching) {
            return false;
        }
        if (this.mergeFree != other.mergeFree) {
            return false;
        }
        if (this.conflictFree != other.conflictFree) {
            return false;
        }
        if (this.homogeneous != other.homogeneous) {
            return false;
        }
        if (this.behaviourallyConflictFree != other.behaviourallyConflictFree) {
            return false;
        }
        if (this.binaryConflictFree != other.binaryConflictFree) {
            return false;
        }
        return this.equalConflict == other.equalConflict;
    }

    public String toString() {
        ArrayList<String> tmpList = new ArrayList<String>();
        if (this.isSafe()) {
            tmpList.add("safe");
        } else if (this.isKBounded()) {
            tmpList.add(this.getKForKBounded() + "-bounded");
        }
        if (this.isKMarking()) {
            tmpList.add(this.getKForKMarking() + "-marking");
        }
        if (this.isPure()) {
            tmpList.add("pure");
        }
        if (this.isPlain()) {
            tmpList.add("plain");
        }
        if (this.isTNet()) {
            tmpList.add("tnet");
        }
        if (this.isMarkedGraph()) {
            tmpList.add("marked-graph");
        }
        if (this.isOutputNonbranching()) {
            tmpList.add("output-nonbranching");
        }
        if (this.isMergeFree()) {
            tmpList.add("merge-free");
        }
        if (this.isConflictFree()) {
            tmpList.add("conflict-free");
        }
        if (this.isHomogeneous()) {
            tmpList.add("homogeneous");
        }
        if (this.isBehaviourallyConflictFree()) {
            tmpList.add("behaviourally-conflict-free");
        }
        if (this.isBinaryConflictFree()) {
            tmpList.add("binary-conflict-free");
        }
        if (tmpList.isEmpty()) {
            return "[]";
        }
        Iterator iter = tmpList.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append((String)iter.next());
        while (iter.hasNext()) {
            sb.append(", ");
            sb.append((String)iter.next());
        }
        sb.append(']');
        return sb.toString();
    }
}

