/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.exception.ArcExistsException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.InvalidRegionException;
import uniol.apt.analysis.synthesize.MissingLocationException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.analysis.synthesize.separation.UnsupportedPNPropertiesException;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class OverapproximatePN {
    private static PNProperties supportedProperties = new PNProperties().requireKBounded(0).setPure(true).setPlain(true).setTNet(true).setMarkedGraph(true);

    private OverapproximatePN() {
    }

    private static void checkSupported(TransitionSystem ts, PNProperties properties) throws MissingLocationException, UnsupportedPNPropertiesException {
        if (properties.isKBounded()) {
            return;
        }
        if (!supportedProperties.containsAll(properties)) {
            throw new UnsupportedPNPropertiesException("Some of the requested properties are not supported for over-approximation; requested: " + properties + "; supported: " + supportedProperties + " (plus anything combined with k-bounded)");
        }
        String[] locationMap = SeparationUtility.getLocationMap(new RegionUtility(ts), properties);
        if (Collections.frequency(Arrays.asList(locationMap), null) != locationMap.length) {
            throw new UnsupportedPNPropertiesException("Overapproximation is not possible with locations and without k-bounded");
        }
    }

    public static PetriNet overapproximate(TransitionSystem ts, PNProperties properties) throws MissingLocationException, UnsupportedPNPropertiesException {
        OverapproximatePN.checkSupported(ts, properties);
        ts = OverapproximatePN.getReachablePart(ts);
        SynthesizePN synthesize = null;
        int iterations = 0;
        do {
            DebugUtil.debug();
            DebugUtil.debugFormat("Beginning iteration %d", ++iterations);
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            SynthesizePN.Builder builder = SynthesizePN.Builder.createForIsomorphicBehaviour(ts).setProperties(properties);
            if (synthesize != null) {
                OverapproximatePN.copyExistingRegions(builder, synthesize, properties);
            }
            synthesize = builder.build();
            ts = OverapproximatePN.handleSeparationFailures(ts, synthesize.getFailedStateSeparationProblems(), synthesize.getFailedEventStateSeparationProblems());
        } while (!synthesize.wasSuccessfullySeparated());
        return synthesize.synthesizePetriNet();
    }

    private static TransitionSystem getReachablePart(TransitionSystem ts) {
        TransitionSystem result = new TransitionSystem();
        State stateToHandle = ts.getInitialState();
        HashSet<State> handled = new HashSet<State>(Collections.singleton(stateToHandle));
        ArrayDeque<State> todo = new ArrayDeque<State>();
        while (stateToHandle != null) {
            result.createState(stateToHandle);
            for (State next : stateToHandle.getPostsetNodes()) {
                if (!handled.add(next)) continue;
                todo.add(next);
            }
            stateToHandle = (State)todo.poll();
        }
        stateToHandle = ts.getInitialState();
        handled = new HashSet<State>(Collections.singleton(stateToHandle));
        todo = new ArrayDeque();
        while (stateToHandle != null) {
            for (Arc arc : stateToHandle.getPostsetEdges()) {
                State next = (State)arc.getTarget();
                result.createArc(arc);
                if (!handled.add(next)) continue;
                todo.add(next);
            }
            stateToHandle = (State)todo.poll();
        }
        result.setInitialState(ts.getInitialState());
        return result;
    }

    private static void copyExistingRegions(SynthesizePN.Builder builder, SynthesizePN synthesize, PNProperties properties) {
        RegionUtility utility = builder.getRegionUtility();
        for (Region region : synthesize.getSeparatingRegions()) {
            Region newRegion = Region.Builder.copyRegionToUtility(utility, region);
            assert (region.toString().equals(newRegion.toString())) : region.toString() + " = " + newRegion.toString();
            assert (!properties.isKBounded() || OverapproximatePN.isKBounded(newRegion, properties.getKForKBounded())) : region;
            try {
                builder.addRegion(newRegion);
            }
            catch (InvalidRegionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static boolean isKBounded(Region region, int k) {
        TransitionSystem ts = region.getRegionUtility().getTransitionSystem();
        BigInteger bigK = BigInteger.valueOf(k);
        for (State state : ts.getNodes()) {
            try {
                BigInteger marking = region.getMarkingForState(state);
                if (marking.compareTo(bigK) <= 0) continue;
                return false;
            }
            catch (UnreachableException e) {
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    public static TransitionSystem handleSeparationFailures(TransitionSystem ts, Collection<Set<State>> failedSSP, Map<String, Set<State>> failedESSP) {
        DebugUtil.debugFormat("Creating new TS to handle SSP failures %s and ESSP failures %s", failedSSP, failedESSP);
        TransitionSystem result = ts;
        HashMap<State, State> oldToNewStateMap = null;
        if (!failedSSP.isEmpty()) {
            State newState;
            result = new TransitionSystem();
            oldToNewStateMap = new HashMap<State, State>();
            for (Set set : failedSSP) {
                for (Object state : set) {
                    oldToNewStateMap.put((State)state, (State)null);
                }
            }
            for (State state : ts.getNodes()) {
                if (oldToNewStateMap.containsKey(state)) continue;
                newState = result.createState(state);
                oldToNewStateMap.put(state, newState);
            }
            for (Set set : failedSSP) {
                newState = result.createState();
                for (State state : set) {
                    oldToNewStateMap.put(state, newState);
                }
            }
            result.setInitialState((State)oldToNewStateMap.get(ts.getInitialState()));
            for (Arc arc : ts.getEdges()) {
                State source = (State)oldToNewStateMap.get(arc.getSource());
                State target = (State)oldToNewStateMap.get(arc.getTarget());
                String label = arc.getLabel();
                try {
                    result.createArc(source, target, label);
                }
                catch (ArcExistsException arcExistsException) {}
            }
        }
        if (!failedESSP.isEmpty()) {
            for (Map.Entry entry : failedESSP.entrySet()) {
                String label = (String)entry.getKey();
                for (State state : (Set)entry.getValue()) {
                    State stateToModify = oldToNewStateMap == null ? state : (State)oldToNewStateMap.get(state);
                    if (stateToModify.getPostsetNodesByLabel(label).isEmpty()) {
                        result.createArc(stateToModify, result.createState(), label);
                        continue;
                    }
                    assert (!failedSSP.isEmpty());
                }
            }
        }
        return result;
    }
}

