/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.MissingLocationException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.RegionUtility;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.UnreachableException;
import uniol.apt.analysis.synthesize.separation.SMTInterpolHelper;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.DifferentPairsIterable;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.UncheckedInterruptedException;

public class MinimizePN {
    private final SynthesizePN synthesize;
    private final RegionUtility utility;
    private final Set<Region> regions;
    private final boolean onlyEventSeparation;

    public MinimizePN(SynthesizePN synthesize) {
        this.synthesize = synthesize;
        this.utility = synthesize.getUtility();
        this.onlyEventSeparation = synthesize.onlyEventSeparation();
        if (!synthesize.wasSuccessfullySeparated()) {
            throw new UnsupportedOperationException("Net was not successfully synthesized and thus cannot be minimized");
        }
        try {
            Set<Region> separatingRegions = synthesize.getSeparatingRegions();
            while (!separatingRegions.isEmpty()) {
                DebugUtil.debugFormat("Have solution with %d regions, trying to find solution with one region less", separatingRegions.size());
                Set<Region> newRegions = this.synthesizeWithLimit(separatingRegions.size() - 1);
                if (newRegions == null) break;
                SynthesizePN.minimizeRegions(this.utility.getTransitionSystem(), newRegions, this.onlyEventSeparation);
                separatingRegions = newRegions;
            }
            DebugUtil.debug("Could not reduce number of regions any more");
            this.regions = Collections.unmodifiableSet(separatingRegions);
        }
        catch (UnreachableException e) {
            throw new RuntimeException("Previous synthesis was successful and now an unreachable state shows up?!", e);
        }
    }

    public Set<Region> getSeparatingRegions() {
        return Collections.unmodifiableSet(this.regions);
    }

    public PetriNet synthesizePetriNet() {
        return this.synthesize.synthesizePetriNet(this.regions);
    }

    private Set<Region> synthesizeWithLimit(int limit) throws UnreachableException {
        Set<Region> result = this.synthesizeWithLimit(limit, Collections.emptySet());
        if (result == null || this.onlyEventSeparation) {
            return result;
        }
        HashSet<State> statesToSeparate = new HashSet<State>();
        do {
            Set<State> unseparated = SynthesizePN.calculateUnseparatedStates(this.utility.getTransitionSystem().getNodes(), result);
            DebugUtil.debug((Object)"Current solution: ", result);
            DebugUtil.debug((Object)"Unseparated states: ", unseparated);
            if (unseparated.isEmpty()) {
                return result;
            }
            statesToSeparate.addAll(unseparated);
            DebugUtil.debug((Object)"Trying again, now separating ", statesToSeparate);
        } while ((result = this.synthesizeWithLimit(limit, statesToSeparate)) != null);
        return result;
    }

    private Set<Region> synthesizeWithLimit(int limit, Set<State> statesToSeparate) throws UnreachableException {
        Script.LBool isSat;
        SMTInterpolHelper helper;
        TransitionSystem ts = this.utility.getTransitionSystem();
        List<String> eventList = this.utility.getEventList();
        int numberEvents = this.utility.getNumberOfEvents();
        PNProperties properties = this.synthesize.getProperties();
        boolean pure = properties.isPure();
        try {
            helper = new SMTInterpolHelper(this.utility, properties.setOutputNonbranching(false), SeparationUtility.getLocationMap(this.utility, properties));
        }
        catch (MissingLocationException e) {
            throw new RuntimeException("Previous synthesis was successful and now we have a missing location!?", e);
        }
        Script script = helper.getScript();
        Term[][] effects = new Term[limit][];
        for (int i = 0; i < limit; ++i) {
            String suffix;
            int n;
            Object region;
            effects[i] = new Term[numberEvents];
            if (pure) {
                region = new Term[1 + numberEvents];
                for (n = 0; n < numberEvents; ++n) {
                    suffix = eventList.get(n) + "-" + i;
                    script.declareFun("e-" + suffix, new Sort[0], script.sort("Int", new Sort[0]));
                    region[1 + n] = script.term("e-" + suffix, new Term[0]);
                    effects[i][n] = region[1 + n];
                }
            } else {
                region = new Term[1 + 2 * numberEvents];
                for (n = 0; n < numberEvents; ++n) {
                    suffix = eventList.get(n) + "-" + i;
                    script.declareFun("b-" + suffix, new Sort[0], script.sort("Int", new Sort[0]));
                    script.declareFun("f-" + suffix, new Sort[0], script.sort("Int", new Sort[0]));
                    region[1 + n] = script.term("b-" + suffix, new Term[0]);
                    region[1 + n + numberEvents] = script.term("f-" + suffix, new Term[0]);
                    effects[i][n] = script.term("-", new Term[]{region[1 + n + numberEvents], region[1 + n]});
                }
            }
            script.declareFun("m0-" + i, new Sort[0], script.sort("Int", new Sort[0]));
            region[0] = script.term("m0-" + i, new Term[0]);
            script.assertTerm(script.term("isRegion", (Term[])region));
        }
        boolean firstProblem = true;
        for (Pair pair : new SynthesizePN.EventStateSeparationProblems(ts)) {
            if (limit == 0) {
                script.assertTerm(script.term("false", new Term[0]));
                break;
            }
            int candidateRegions = firstProblem ? 1 : limit;
            Term[] problemSolved = new Term[candidateRegions];
            for (int i = 0; i < candidateRegions; ++i) {
                Term term = helper.evaluateReachingParikhVector(script.term("m0-" + i, new Term[0]), effects[i], (State)pair.getFirst());
                term = pure ? script.term("+", term, script.term("e-" + (String)pair.getSecond() + "-" + i, new Term[0])) : script.term("-", term, script.term("b-" + (String)pair.getSecond() + "-" + i, new Term[0]));
                problemSolved[i] = script.term(">", script.numeral(BigInteger.ZERO), term);
            }
            script.assertTerm(this.collectTerms(script, "or", problemSolved, "false"));
            firstProblem = false;
        }
        if (this.onlyEventSeparation) {
            assert (statesToSeparate.isEmpty());
        } else {
            for (Pair pair : new DifferentPairsIterable<State>(statesToSeparate)) {
                Term[] problemSolved = new Term[limit];
                State state1 = (State)pair.getFirst();
                State state2 = (State)pair.getSecond();
                for (int i = 0; i < limit; ++i) {
                    Term pv0 = helper.evaluateReachingParikhVector(script.term("m0-" + i, new Term[0]), effects[i], state1);
                    Term pv1 = helper.evaluateReachingParikhVector(script.term("m0-" + i, new Term[0]), effects[i], state2);
                    problemSolved[i] = script.term("not", script.term("=", pv0, pv1));
                }
                script.assertTerm(this.collectTerms(script, "or", problemSolved, "false"));
            }
        }
        if ((isSat = script.checkSat()) == Script.LBool.UNKNOWN) {
            assert (ReasonUnknown.TIMEOUT.equals(script.getInfo(":reason-unknown"))) : script.getInfo(":reason-unknown");
            throw new UncheckedInterruptedException();
        }
        if (isSat == Script.LBool.UNSAT) {
            return null;
        }
        Model model = script.getModel();
        HashSet<Region> result = new HashSet<Region>();
        for (int numRegion = 0; numRegion < limit; ++numRegion) {
            Region.Builder r;
            if (pure) {
                ArrayList<BigInteger> weights = new ArrayList<BigInteger>();
                for (String event : eventList) {
                    weights.add(this.getValue(model, script.term("e-" + event + "-" + numRegion, new Term[0])));
                }
                r = Region.Builder.createPure(this.utility, weights);
            } else {
                ArrayList<BigInteger> backwardWeights = new ArrayList<BigInteger>();
                ArrayList<BigInteger> forwardWeights = new ArrayList<BigInteger>();
                for (String event : eventList) {
                    backwardWeights.add(this.getValue(model, script.term("b-" + event + "-" + numRegion, new Term[0])));
                    forwardWeights.add(this.getValue(model, script.term("f-" + event + "-" + numRegion, new Term[0])));
                }
                r = new Region.Builder(this.utility, backwardWeights, forwardWeights);
            }
            BigInteger initialMarking = this.getValue(model, script.term("m0-" + numRegion, new Term[0]));
            result.add(r.withInitialMarking(initialMarking));
        }
        return result;
    }

    private BigInteger getValue(Model model, Term term) {
        Term evald = model.evaluate(term);
        assert (evald instanceof ConstantTerm) : evald;
        Object value = ((ConstantTerm)evald).getValue();
        assert (value instanceof Rational) : value;
        Rational rat = (Rational)value;
        assert (rat.denominator().equals(BigInteger.ONE)) : value;
        return rat.numerator();
    }

    private Term collectTerms(Script script, String operation, Term[] terms, String def) {
        switch (terms.length) {
            case 0: {
                return script.term(def, new Term[0]);
            }
            case 1: {
                return terms[0];
            }
        }
        return script.term(operation, terms);
    }
}

