/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.LimitedUnfolding;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class LimitedUnfoldingModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Calculate the limited unfolding of a lts";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". The limited unfolding, as defined in 'Petri Net Synthesis' (E. Badouel, L. Bernardinello and P. Darondeau) eliminates paths that reach the same state (where possible) without changing the language of the LTS.";
    }

    @Override
    public String getName() {
        return "limited_unfolding";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be unfolded", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("lts", TransitionSystem.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        output.setReturnValue("lts", TransitionSystem.class, LimitedUnfolding.calculateLimitedUnfolding(ts));
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

