/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.extension.ExtensionProperty;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.deterministic.Deterministic;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class LimitedUnfolding {
    private static final String NEW_STATE_KEY = "NEW_STATE";
    public static final String ORIGINAL_STATE_KEY = "ORIGINAL_STATE";

    private LimitedUnfolding() {
    }

    public static TransitionSystem calculateLimitedUnfolding(TransitionSystem ts) throws NonDeterministicException {
        new Deterministic(ts).throwIfNonDeterministic();
        TransitionSystem unfolding = new TransitionSystem("Limited unfolding of " + ts.getName());
        LinkedList<DFSState> stack = new LinkedList<DFSState>();
        unfolding.setInitialState(LimitedUnfolding.createState(unfolding, stack, ts.getInitialState()));
        while (!stack.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            Arc arc = ((DFSState)stack.getFirst()).getNextArc();
            if (arc == null) {
                ((DFSState)stack.getFirst()).oldState.removeExtension(NEW_STATE_KEY);
                stack.removeFirst();
                continue;
            }
            State state = LimitedUnfolding.getNewState(((DFSState)stack.getFirst()).oldState);
            State newTarget = LimitedUnfolding.getNewState((State)arc.getTarget());
            if (newTarget == null) {
                newTarget = LimitedUnfolding.createState(unfolding, stack, (State)arc.getTarget());
            }
            unfolding.createArc(state, newTarget, arc.getLabel()).copyExtensions(arc);
        }
        return unfolding;
    }

    private static State createState(TransitionSystem unfolding, Deque<DFSState> stack, State next) {
        State newState = unfolding.createState();
        newState.copyExtensions(next);
        next.putExtension(NEW_STATE_KEY, newState);
        newState.putExtension(ORIGINAL_STATE_KEY, next);
        newState.putExtension("original_state", next.getId(), ExtensionProperty.WRITE_TO_FILE);
        stack.addFirst(new DFSState(next));
        return newState;
    }

    private static State getNewState(State state) {
        try {
            return (State)state.getExtension(NEW_STATE_KEY);
        }
        catch (StructureException e) {
            return null;
        }
    }

    private static class DFSState {
        public final State oldState;
        public final Iterator<Arc> oldStatePostset;

        public DFSState(State oldState) {
            this.oldState = oldState;
            this.oldStatePostset = oldState.getPostsetEdges().iterator();
        }

        public Arc getNextArc() {
            if (!this.oldStatePostset.hasNext()) {
                return null;
            }
            return this.oldStatePostset.next();
        }
    }
}

