/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import uniol.apt.analysis.synthesize.AbstractSynthesizeModule;
import uniol.apt.analysis.synthesize.FindWords;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.SynthesizeUtils;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class FindWordsModule
extends AbstractModule
implements Module {
    @Override
    public String getShortDescription() {
        return "Print either minimal unsolvable or all solvable words of some class";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nThis module only prints a subset of all words. For this, an equivalence relation on words is used were two words are equivalent if one can be created from the other by replacing letters with other letters. For example, 'abc' and 'abd' are equivalent in this sense, since c->d turns one into the other.\nMore concretely, words are generated so that the last letter of the word is the first letter of the alphabet. Then, the next new letter from the end is the second letter of the alphabet, and so on.\n\nExample calls:\n\n apt " + this.getName() + " safe solvable abc: Print all words solvable by safe Petri nets over the alphabet {a,b,c}\n apt " + this.getName() + " none unsolvable ab: Print all minimally unsolvable words over the alphabet {a,b}\n";
    }

    @Override
    public String getName() {
        return "find_words";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("options", String.class, "options", new String[0]);
        inputSpec.addParameter("operation", String.class, "Choose between printing all 'minimal_unsolvable' words or all 'solvable' words", new String[0]);
        inputSpec.addParameter("alphabet", String.class, "Letters that should be part of the alphabet", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        String optionsStr = input.getParameter("options", String.class);
        String alphabetLetter = input.getParameter("alphabet", String.class);
        String operation = input.getParameter("operation", String.class);
        PNProperties properties = AbstractSynthesizeModule.Options.parseProperties((String)optionsStr).properties;
        TreeSet<Character> alphabet = new TreeSet<Character>(FindWords.toList(alphabetLetter));
        switch (operation) {
            case "minimal_unsolvable": {
                FindWordsModule.generateList(properties, alphabet, Operation.UNSOLVABLE);
                break;
            }
            case "solvable": {
                FindWordsModule.generateList(properties, alphabet, Operation.SOLVABLE);
                break;
            }
            default: {
                throw new ModuleException("Unknown operation '" + operation + "', valid options are 'minimal_unsolvable' and 'solvable'");
            }
        }
    }

    private static void generateList(PNProperties properties, SortedSet<Character> alphabet, Operation operation) throws ModuleException {
        final boolean printSolvable = operation.printSolvable();
        final boolean printUnsolvable = operation.printUnsolvable();
        if (operation.printStatus()) {
            String print = printSolvable && printUnsolvable ? "solvable and minimal unsolvable" : (printSolvable ? "solvable" : (printUnsolvable ? "minimal unsolvable" : "no"));
            System.out.println("Looking for " + print + " words from class " + properties.toString() + " over the alphabet " + alphabet);
        }
        final int[] counters = new int[2];
        boolean solvable = false;
        boolean unsolvable = true;
        FindWords.WordCallback wordCallback = new FindWords.WordCallback(){

            @Override
            public void call(List<Character> wordAsList, String wordAsString, SynthesizePN synthesize) {
                if (synthesize.wasSuccessfullySeparated()) {
                    counters[0] = counters[0] + 1;
                    if (printSolvable) {
                        System.out.println(wordAsString);
                    }
                } else {
                    counters[1] = counters[1] + 1;
                    if (printUnsolvable) {
                        String msg = SynthesizeUtils.formatESSPFailure(FindWords.toStringList(wordAsList), synthesize.getFailedEventStateSeparationProblems(), true);
                        System.out.println(msg);
                    }
                }
            }
        };
        FindWords.LengthDoneCallback lengthDoneCallback = new FindWords.LengthDoneCallback(){

            @Override
            public void call(int length) {
                System.out.println("Done with length " + length + ". There were " + counters[1] + " unsolvable words and " + counters[0] + " solvable words.");
                counters[0] = 0;
                counters[1] = 0;
            }
        };
        FindWords.generateList(properties, alphabet, !printUnsolvable, wordCallback, lengthDoneCallback);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }

    private static enum Operation {
        UNSOLVABLE(true, true, false),
        SOLVABLE(true, false, true),
        QUIET(false, false, false);

        private final boolean status;
        private final boolean unsolvable;
        private final boolean solvable;

        private Operation(boolean status, boolean unsolvable, boolean solvable) {
            this.status = status;
            this.unsolvable = unsolvable;
            this.solvable = solvable;
        }

        private boolean printStatus() {
            return this.status;
        }

        private boolean printUnsolvable() {
            return this.unsolvable;
        }

        private boolean printSolvable() {
            return this.solvable;
        }
    }
}

