/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.iterators.EmptyIterator;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.exception.NonDeterministicException;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.synthesize.MissingLocationException;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.SynthesizeUtils;
import uniol.apt.util.Pair;

public class FindWords {
    private static final int TARGET_JOB_QUEUE_SIZE = 5;

    private FindWords() {
    }

    private static SynthesizePN solveWord(List<Character> wordList, PNProperties properties, boolean quickFail) {
        TransitionSystem ts = SynthesizeUtils.makeTS(FindWords.toStringList(wordList));
        try {
            return SynthesizePN.Builder.createForLanguageEquivalence(ts).setProperties(properties).setQuickFail(quickFail).build();
        }
        catch (MissingLocationException e) {
            throw new RuntimeException("Not generating locations and  yet they were generated wrongly?!", e);
        }
        catch (NonDeterministicException e) {
            throw new RuntimeException("Generated a deterministic TS and  yet it is non-deterministic?!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateList(PNProperties properties, SortedSet<Character> alphabet, boolean quickFail, WordCallback wordCallback, LengthDoneCallback lengthDoneCallback) throws PreconditionFailedException {
        ForkJoinPool executor = new ForkJoinPool();
        try {
            FindWords.generateList(properties, alphabet, quickFail, wordCallback, lengthDoneCallback, executor);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private static void generateList(final PNProperties properties, SortedSet<Character> alphabet, final boolean quickFail, WordCallback wordCallback, LengthDoneCallback lengthDoneCallback, ForkJoinPool executor) throws PreconditionFailedException {
        if (properties.isPlain() && properties.isKMarking()) {
            throw new PreconditionFailedException("The combination of plain and k-marking is not supported, because 'minimal unsolvable' cannot be defined");
        }
        ExecutorCompletionService completion = new ExecutorCompletionService(executor);
        List<String> currentLevel = Collections.singletonList("");
        while (!currentLevel.isEmpty()) {
            Iterator jobGenerator = IteratorUtils.transformedIterator(new NextWordsIterator(properties, alphabet, currentLevel), new Transformer<String, Callable<Pair<String, SynthesizePN>>>(){

                @Override
                public Callable<Pair<String, SynthesizePN>> transform(final String word) {
                    return new Callable<Pair<String, SynthesizePN>>(){

                        @Override
                        public Pair<String, SynthesizePN> call() {
                            List<Character> wordList = FindWords.toList(word);
                            SynthesizePN synthesize = FindWords.solveWord(wordList, properties, quickFail);
                            return new Pair<String, SynthesizePN>(word, synthesize);
                        }
                    };
                }
            });
            ArrayList<String> nextLevel = new ArrayList<String>();
            int tasksSubmitted = FindWords.submitTasks(executor, completion, jobGenerator);
            for (int tasksFinished = 0; tasksSubmitted != tasksFinished; ++tasksFinished, tasksSubmitted += FindWords.submitTasks(executor, completion, jobGenerator)) {
                SynthesizePN synthesize;
                String word;
                try {
                    Pair pair = (Pair)completion.take().get();
                    word = (String)pair.getFirst();
                    synthesize = (SynthesizePN)pair.getSecond();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                List<Character> wordList = FindWords.toList(word);
                wordCallback.call(wordList, word, synthesize);
                if (!synthesize.wasSuccessfullySeparated()) continue;
                nextLevel.add(word);
            }
            int currentLength = currentLevel.iterator().next().length() + 1;
            lengthDoneCallback.call(currentLength);
            currentLevel = nextLevel;
            Collections.sort(currentLevel);
        }
    }

    private static <T> int submitTasks(ForkJoinPool executor, CompletionService<T> completion, Iterator<Callable<T>> jobGenerator) {
        int submitted = 0;
        while (jobGenerator.hasNext() && executor.getQueuedSubmissionCount() < 5) {
            completion.submit(jobGenerator.next());
            ++submitted;
        }
        return submitted;
    }

    static List<Character> toList(String word) {
        ArrayList<Character> result = new ArrayList<Character>(word.length());
        for (int i = 0; i < word.length(); ++i) {
            result.add(Character.valueOf(word.charAt(i)));
        }
        return result;
    }

    static List<String> toStringList(List<Character> argument) {
        ArrayList<String> result = new ArrayList<String>(argument.size());
        for (char c : argument) {
            result.add(String.valueOf(c));
        }
        return result;
    }

    private static String normalizeWord(List<Character> word, SortedSet<Character> alphabet) {
        StringBuilder result = new StringBuilder();
        HashMap<Character, Character> morphism = new HashMap<Character, Character>();
        Iterator alphabetIter = alphabet.iterator();
        for (Character letter : word) {
            Character replacement = (Character)morphism.get(letter);
            if (replacement == null) {
                assert (alphabetIter.hasNext());
                replacement = (Character)alphabetIter.next();
                morphism.put(letter, replacement);
            }
            result.append(replacement);
        }
        return result.toString();
    }

    private static class NextWordsIterator
    implements Iterator<String> {
        private final PNProperties properties;
        private final SortedSet<Character> alphabet;
        private final List<String> solvableShorterWords;
        private final Iterator<String> solvableWordsIterator;
        private Iterator<Character> alphabetIterator = EmptyIterator.emptyIterator();
        private String currentWordToExtend = null;
        private String nextWord = null;

        public NextWordsIterator(PNProperties properties, SortedSet<Character> alphabet, List<String> solvableShorterWords) {
            this.properties = properties;
            this.alphabet = alphabet;
            this.solvableShorterWords = solvableShorterWords;
            this.solvableWordsIterator = solvableShorterWords.iterator();
            if (alphabet.isEmpty()) {
                throw new IllegalArgumentException("Alphabet must not be empty");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextWord != null) {
                return true;
            }
            while (this.alphabetIterator.hasNext() || this.solvableWordsIterator.hasNext()) {
                Character c;
                if (!this.alphabetIterator.hasNext()) {
                    this.currentWordToExtend = this.solvableWordsIterator.next();
                    this.alphabetIterator = this.alphabet.iterator();
                    assert (this.alphabetIterator.hasNext());
                }
                boolean newLetter = this.currentWordToExtend.indexOf((c = this.alphabetIterator.next()).charValue()) == -1;
                String word = c + this.currentWordToExtend;
                word = FindWords.normalizeWord(FindWords.toList(word), this.alphabet);
                if (!this.properties.isKBounded() && Collections.binarySearch(this.solvableShorterWords, word.substring(0, word.length() - 1)) < 0) continue;
                this.nextWord = word;
                if (newLetter) {
                    this.alphabetIterator = EmptyIterator.emptyIterator();
                }
                return true;
            }
            return false;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String result = this.nextWord;
            this.nextWord = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface LengthDoneCallback {
        public void call(int var1);
    }

    public static interface WordCallback {
        public void call(List<Character> var1, String var2, SynthesizePN var3);
    }
}

