/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synthesize;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synthesize.MinimizePN;
import uniol.apt.analysis.synthesize.PNProperties;
import uniol.apt.analysis.synthesize.Region;
import uniol.apt.analysis.synthesize.SynthesizePN;
import uniol.apt.analysis.synthesize.separation.SeparationUtility;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public abstract class AbstractSynthesizeModule
extends AbstractModule
implements InterruptibleModule {
    static String getOptionsDescription(String extraOptions, String extraOptionsDescriptions) {
        return "Supported options are: none, [k]-bounded, safe, [k]-marking, pure, plain, tnet, generalized-marked-graph (gmg), marked-graph (mg), generalized-output-nonbranching (gon) output-nonbranching (on), merge-free (mf), conflict-free (cf), homogeneous, behaviourally-conflict-free (bcf), binary-conflict-free (bicf), equal-conflict (ec), upto-language-equivalence (language, le), " + extraOptions + "minimize (minimal), verbose and quick-fail.\n\nThe meaning of these options is as follows:\n - none: No further requirements are made.\n - [k]-bounded: In every reachable marking, every place contains at most [k] tokens.\n - safe: Equivalent to 1-bounded.\n - [k]-marking: The initial marking of each place is a multiple of k.\n - pure: Every transition either consumes or produces tokens on a place, but not both (=no side-conditions).\n - plain: Every flow has a weight of at most one.\n - tnet: Every place's preset and postset contains at most one entry.\n - generalized-marked-graph: Every place's preset and postset contains exactly one entry.\n - marked-graph: generalized-marked-graph + plain.\n - generalized-output-nonbranching: Every place's postset contains at most one entry.\n - output-nonbranching: generalized-output-nonbranching + plain.\n - merge-free: Every place's pretset contains at most one entry.\n - conflict-free: The Petri net is plain and every place either has at most one entry in its postset or its preset is contained in its postset.\n - homogeneous: All outgoing flows from a place have the same weight.\n - behaviourally-conflict-free: In every reachable marking, the preset of activated transitions is disjoint.\n - binary-conflict-free: For every reachable marking and pair of activated transitions, enough tokens for both transitions are present.\n - equal-conflict: The Petri net is homogeneous and two transitions with non-disjoint presets have equal presets.\n - minimize: The Petri net has as few places as possible.\n" + extraOptionsDescriptions + "The following options only affect the output, but not the produced Petri net:\n - verbose: Print details about each calculated region/place.\n - quick-fail: Stop the algorithm when the result 'success: No' is clear.";
    }

    protected abstract void requireExtra(ModuleInputSpec var1);

    @Override
    public final void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("options", String.class, "Comma separated list of options", new String[0]);
        this.requireExtra(inputSpec);
    }

    protected abstract void provideExtra(ModuleOutputSpec var1);

    @Override
    public final void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("success", Boolean.class, "success");
        outputSpec.addReturnValue("solvedEventStateSeparationProblems", String.class, new String[0]);
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
        this.provideExtra(outputSpec);
    }

    public SynthesizePN runSynthesis(TransitionSystemForOptions tsForOpts, ModuleInput input, ModuleOutput output) throws ModuleException {
        return this.runSynthesis(tsForOpts, null, input, output);
    }

    public SynthesizePN runSynthesis(TransitionSystemForOptions tsForOpts, ConfigureSynthesizePNBuilder configure, ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn;
        Set<Region> regions;
        SynthesizePN synthesize;
        String quickFailStr = "quick-fail";
        String verboseStr = "verbose";
        List<String> languageEquivalenceStr = Arrays.asList("upto-language-equivalence", "language", "le");
        List<String> minimizeStr = Arrays.asList("minimize", "minimise", "minimal");
        HashSet<String> supportedExtraOptions = new HashSet<String>(Arrays.asList(quickFailStr, verboseStr));
        supportedExtraOptions.addAll(languageEquivalenceStr);
        supportedExtraOptions.addAll(minimizeStr);
        supportedExtraOptions.addAll(tsForOpts.supportedExtraOptions());
        Options options = Options.parseProperties(input.getParameter("options", String.class), supportedExtraOptions);
        boolean quickFail = options.extraOptions.contains(quickFailStr);
        boolean verbose = options.extraOptions.contains(verboseStr);
        boolean languageEquivalence = !Collections.disjoint(options.extraOptions, languageEquivalenceStr);
        boolean minimize = !Collections.disjoint(options.extraOptions, minimizeStr);
        TransitionSystem ts = tsForOpts.getTS(options.extraOptions);
        SynthesizePN.Builder builder = languageEquivalence ? SynthesizePN.Builder.createForLanguageEquivalence(ts) : SynthesizePN.Builder.createForIsomorphicBehaviour(ts);
        builder.setProperties(options.properties).setQuickFail(quickFail);
        if (configure != null) {
            configure.configureSynthesizePNBuilder(builder);
        }
        if ((synthesize = builder.build()).wasSuccessfullySeparated() && minimize) {
            MinimizePN min = new MinimizePN(synthesize);
            regions = min.getSeparatingRegions();
            pn = min.synthesizePetriNet();
        } else {
            regions = synthesize.getSeparatingRegions();
            pn = synthesize.synthesizePetriNet();
        }
        output.setReturnValue("success", Boolean.class, synthesize.wasSuccessfullySeparated());
        output.setReturnValue("pn", PetriNet.class, pn);
        if (verbose) {
            output.setReturnValue("solvedEventStateSeparationProblems", String.class, AbstractSynthesizeModule.getSolvedEventStateSeparationProblems(synthesize.getUtility().getTransitionSystem(), regions));
        }
        return synthesize;
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }

    public static Set<String> getStateIDs(Set<State> states) {
        TreeSet<String> result = new TreeSet<String>();
        for (State state : states) {
            result.add(state.getId());
        }
        return result;
    }

    public static String getSolvedEventStateSeparationProblems(TransitionSystem ts, Collection<Region> regions) {
        StringBuilder result = new StringBuilder("");
        for (Region region : regions) {
            result.append("\nRegion ").append(region).append(":");
            for (String event : ts.getAlphabet()) {
                HashSet<State> states = new HashSet<State>();
                for (State state : ts.getNodes()) {
                    if (SeparationUtility.isEventEnabled(state, event) || !SeparationUtility.isSeparatingRegion(region, state, event)) continue;
                    states.add(state);
                }
                if (states.isEmpty()) continue;
                result.append("\n\tseparates event ");
                result.append(event);
                result.append(" at states ");
                result.append(AbstractSynthesizeModule.getStateIDs(states));
            }
        }
        String ret = result.toString();
        if (ret.isEmpty()) {
            return "none";
        }
        return ret;
    }

    public static class Options {
        public final PNProperties properties;
        public final Set<String> extraOptions;

        public Options(PNProperties properties, Collection<String> extraOptions) {
            this.properties = properties;
            this.extraOptions = Collections.unmodifiableSet(new HashSet<String>(extraOptions));
        }

        public static Options parseProperties(String properties) throws ModuleException {
            return Options.parseProperties(properties, Collections.emptySet());
        }

        public static Options parseProperties(String properties, Collection<String> supportedExtraOptions) throws ModuleException {
            PNProperties result = new PNProperties();
            if ((properties = properties.trim()).isEmpty()) {
                return new Options(result, Collections.emptySet());
            }
            HashSet<String> extraOptions = new HashSet<String>();
            block45: for (String prop : properties.split(",")) {
                if (supportedExtraOptions.contains(prop = prop.trim().toLowerCase())) {
                    extraOptions.add(prop);
                    continue;
                }
                switch (prop) {
                    case "none": {
                        continue block45;
                    }
                    case "safe": {
                        result = result.requireSafe();
                        continue block45;
                    }
                    case "pure": {
                        result = result.setPure(true);
                        continue block45;
                    }
                    case "plain": {
                        result = result.setPlain(true);
                        continue block45;
                    }
                    case "tnet": {
                        result = result.setTNet(true);
                        continue block45;
                    }
                    case "generalized-marked-graph": 
                    case "generalised-marked-graph": 
                    case "gmg": {
                        result = result.setMarkedGraph(true);
                        continue block45;
                    }
                    case "marked-graph": 
                    case "mg": {
                        result = result.setMarkedGraph(true).setPlain(true);
                        continue block45;
                    }
                    case "generalized-output-nonbranching": 
                    case "generalised-output-nonbranching": 
                    case "gon": {
                        result = result.setOutputNonbranching(true);
                        continue block45;
                    }
                    case "output-nonbranching": 
                    case "on": {
                        result = result.setOutputNonbranching(true).setPlain(true);
                        continue block45;
                    }
                    case "merge-free": 
                    case "mf": {
                        result = result.setMergeFree(true);
                        continue block45;
                    }
                    case "conflict-free": 
                    case "cf": {
                        result = result.setConflictFree(true);
                        continue block45;
                    }
                    case "homogeneous": {
                        result = result.setHomogeneous(true);
                        continue block45;
                    }
                    case "behaviourally-conflict-free": 
                    case "bcf": {
                        result = result.setBehaviourallyConflictFree(true);
                        continue block45;
                    }
                    case "binary-conflict-free": 
                    case "bicf": {
                        result = result.setBinaryConflictFree(true);
                        continue block45;
                    }
                    case "equal-conflict": 
                    case "ec": {
                        result = result.setEqualConflict(true);
                        continue block45;
                    }
                    default: {
                        if (prop.endsWith("-bounded")) {
                            result = result.requireKBounded(Options.parseInt(prop, "-bounded"));
                            continue block45;
                        }
                        if (prop.endsWith("-marking")) {
                            result = result.requireKMarking(Options.parseInt(prop, "-marking"));
                            continue block45;
                        }
                        throw new ModuleException("Cannot parse '" + prop + "': Unknown property");
                    }
                }
            }
            return new Options(result, extraOptions);
        }

        private static int parseInt(String prop, String suffix) throws ModuleException {
            int k;
            assert (prop.endsWith(suffix));
            String value = prop.substring(0, prop.length() - suffix.length());
            try {
                k = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ModuleException("Cannot parse '" + prop + "': Invalid number for property 'k" + suffix + "'");
            }
            if (k < 1) {
                throw new ModuleException("Cannot parse '" + prop + "': Bound must be positive");
            }
            return k;
        }
    }

    protected static interface ConfigureSynthesizePNBuilder {
        public void configureSynthesizePNBuilder(SynthesizePN.Builder var1);
    }

    protected static interface TransitionSystemForOptions {
        public Collection<String> supportedExtraOptions();

        public TransitionSystem getTS(Collection<String> var1);
    }
}

