/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synet;

import java.io.IOException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.synet.SynetSynthesizeDistributedLTS;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SynthesizeDistributedLTSModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "use_synet";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("synthesize_distributed_lts", Boolean.class, "success");
        outputSpec.addReturnValue("error", String.class, new String[0]);
        outputSpec.addReturnValue("separationError", String.class, new String[0]);
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        SynetSynthesizeDistributedLTS checkLTS = new SynetSynthesizeDistributedLTS(ts);
        try {
            boolean b = checkLTS.check();
            if (checkLTS.getSeparationError() == null) {
                output.setReturnValue("synthesize_distributed_lts", Boolean.class, b);
                output.setReturnValue("separationError", String.class, null);
            } else {
                output.setReturnValue("separationError", String.class, checkLTS.getSeparationError());
            }
            if (b) {
                output.setReturnValue("error", String.class, null);
            } else {
                output.setReturnValue("error", String.class, checkLTS.getError());
            }
        }
        catch (IOException | ParseException | RenderException ex) {
            throw new ModuleException(ex);
        }
        output.setReturnValue("pn", PetriNet.class, checkLTS.getPN());
    }

    @Override
    public String getShortDescription() {
        return "Check if Synet can generate a Petri net from a LTS";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + "\n\nFor this module to function properly you must ensure that the Synet executable can be found on your system. On most systems adding the directory where the executable is located to the PATH environment variable suffices to make it available to the APT system.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

