/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.synet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.io.output.FileWriterWithEncoding;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.Event;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.impl.SynetPNParser;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.impl.SynetLTSRenderer;
import uniol.apt.module.exception.SynetNotFoundException;

public class SynetSynthesizeDistributedLTS {
    private TransitionSystem ts_;
    private PetriNet pn_;
    private String errorMsg_;
    private String separationErrorMsg_;
    private boolean location_;

    public SynetSynthesizeDistributedLTS(TransitionSystem ts) {
        this.ts_ = ts;
        this.location_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check() throws SynetNotFoundException, IOException, ParseException, RenderException {
        String ltsSynetFormat = new SynetLTSRenderer().render(this.ts_);
        File tmpAutFile = null;
        File tmpDisFile = null;
        File tmpSaveFile = null;
        try {
            Process p;
            Throwable throwable;
            BufferedWriter bw;
            tmpAutFile = File.createTempFile("synetAut", ".aut");
            try (FileWriterWithEncoding fw = new FileWriterWithEncoding(tmpAutFile, "UTF-8");){
                bw = new BufferedWriter(fw);
                throwable = null;
                try {
                    bw.write(ltsSynetFormat);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bw != null) {
                        if (throwable != null) {
                            try {
                                bw.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            bw.close();
                        }
                    }
                }
            }
            tmpDisFile = File.createTempFile("synetDis", ".dis");
            fw = new FileWriterWithEncoding(tmpDisFile, "UTF-8");
            var6_6 = null;
            try {
                bw = new BufferedWriter(fw);
                throwable = null;
                try {
                    bw.write(this.getDisString());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (bw != null) {
                        if (throwable != null) {
                            try {
                                bw.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            bw.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var6_6 = throwable6;
                throw throwable6;
            }
            finally {
                if (fw != null) {
                    if (var6_6 != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable7) {
                            var6_6.addSuppressed(throwable7);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
            tmpSaveFile = File.createTempFile("synetNet", ".net");
            if (this.location_) {
                try {
                    p = new ProcessBuilder("synet", "-r", "-o", tmpSaveFile.getAbsolutePath(), "-d", tmpDisFile.getAbsolutePath(), tmpAutFile.getAbsolutePath()).start();
                }
                catch (Exception e) {
                    throw new SynetNotFoundException();
                }
            }
            try {
                p = new ProcessBuilder("synet", "-r", "-o", tmpSaveFile.getAbsolutePath(), tmpAutFile.getAbsolutePath()).start();
            }
            catch (Exception e) {
                throw new SynetNotFoundException();
            }
            try (InputStreamReader errorStream = new InputStreamReader(p.getErrorStream(), "UTF-8");
                 BufferedReader error = new BufferedReader(errorStream);
                 InputStreamReader brStream = new InputStreamReader(p.getInputStream(), "UTF-8");
                 BufferedReader br = new BufferedReader(brStream);){
                String line = "";
                while ((line = br.readLine()) != null) {
                    if (line.contains("failures") || line.contains("not separated")) {
                        if (this.separationErrorMsg_ == null) {
                            this.separationErrorMsg_ = "";
                        }
                        this.separationErrorMsg_ = this.separationErrorMsg_ + line + "\n";
                    }
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.pn_ = (PetriNet)new SynetPNParser().parseFile(tmpSaveFile.getAbsolutePath());
                String errorStr = error.readLine();
                if (errorStr != null) {
                    this.errorMsg_ = errorStr;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (tmpAutFile != null) {
                tmpAutFile.delete();
            }
            if (tmpDisFile != null) {
                tmpDisFile.delete();
            }
            if (tmpSaveFile != null) {
                tmpSaveFile.delete();
            }
        }
    }

    private String getDisString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> labelMem = new ArrayList<String>(0);
        for (Event e : this.ts_.getAlphabetEvents()) {
            try {
                if (e.getExtension("location") == null || labelMem.contains(e.getLabel())) continue;
                sb.append("(" + e.getLabel() + "," + e.getExtension("location").toString().replace("\"", "") + ")");
                sb.append("\n");
                labelMem.add(e.getLabel());
                this.location_ = true;
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    public PetriNet getPN() {
        return this.pn_;
    }

    public String getError() {
        return this.errorMsg_;
    }

    public String getSeparationError() {
        return this.separationErrorMsg_;
    }
}

