/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.sum;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.sum.LabelMismatchException;
import uniol.apt.analysis.sum.Sum;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SumSyncModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "sum_sync";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn1", PetriNet.class, "The first PN of the sum", new String[0]);
        inputSpec.addParameter("pn2", PetriNet.class, "The second PN of the sum", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("sum", PetriNet.class, "raw", "file");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn1 = input.getParameter("pn1", PetriNet.class);
        PetriNet pn2 = input.getParameter("pn2", PetriNet.class);
        Sum sum = new Sum(pn1, pn2);
        try {
            PetriNet result = sum.getSyncSum();
            output.setReturnValue("sum", PetriNet.class, result);
        }
        catch (LabelMismatchException e) {
            throw new ModuleException(e.getMessage(), e);
        }
    }

    @Override
    public String getShortDescription() {
        return "Compute the synchronous sum of two PN";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

