/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.sum;

import java.util.HashMap;
import java.util.Map;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.sum.LabelMismatchException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Sum {
    private final PetriNet pn1;
    private final PetriNet pn2;
    private PetriNet sum;
    private Map<String, Transition> transitionsById;
    private Map<Transition, Transition> transitionCache;
    private Map<Place, Place> placeCache;

    public Sum(PetriNet pn1, PetriNet pn2) {
        this.pn1 = pn1;
        this.pn2 = pn2;
    }

    public PetriNet getAsyncSum() {
        try {
            return this.sum(false);
        }
        catch (LabelMismatchException e) {
            throw new AssertionError((Object)e);
        }
    }

    public PetriNet getSyncSum() throws LabelMismatchException {
        return this.sum(true);
    }

    private PetriNet sum(boolean sync) throws LabelMismatchException {
        this.sum = new PetriNet();
        this.transitionsById = new HashMap<String, Transition>();
        this.transitionCache = new HashMap<Transition, Transition>();
        this.placeCache = new HashMap<Place, Place>();
        for (Flow flow : this.pn1.getEdges()) {
            this.processFlow(flow, sync);
        }
        for (Flow flow : this.pn2.getEdges()) {
            this.processFlow(flow, sync);
        }
        return this.sum;
    }

    private void processFlow(Flow flow, boolean match) throws LabelMismatchException {
        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
        Node source = (Node)flow.getSource();
        Node target = (Node)flow.getTarget();
        if (source instanceof Place && target instanceof Transition) {
            assert (source == flow.getPlace());
            assert (target == flow.getTransition());
            source = this.createOrGetPlace(flow.getPlace());
            target = this.createOrGetTransition(flow.getTransition(), match);
        } else {
            assert (source == flow.getTransition());
            assert (target == flow.getPlace());
            source = this.createOrGetTransition(flow.getTransition(), match);
            target = this.createOrGetPlace(flow.getPlace());
        }
        this.sum.createFlow(source, target, flow.getWeight());
    }

    private Node createOrGetTransition(Transition sourceTransition, boolean match) throws LabelMismatchException {
        if (match) {
            return this.createOrGetTransitionById(sourceTransition);
        }
        return this.createOrGetTransition(sourceTransition);
    }

    private Node createOrGetTransition(Transition sourceTransition) {
        if (!this.transitionCache.containsKey(sourceTransition)) {
            Transition sumTransition = this.sum.containsTransition(sourceTransition.getId()) ? this.sum.createTransition() : this.sum.createTransition(sourceTransition.getId());
            this.transitionCache.put(sourceTransition, sumTransition);
            return sumTransition;
        }
        return this.transitionCache.get(sourceTransition);
    }

    private Transition createOrGetTransitionById(Transition sourceTransition) throws LabelMismatchException {
        String id = sourceTransition.getId();
        String label = sourceTransition.getLabel();
        if (!this.transitionsById.containsKey(id)) {
            Transition sumTransition = this.sum.createTransition(id, label);
            this.transitionsById.put(id, sumTransition);
            return sumTransition;
        }
        Transition sumTransition = this.transitionsById.get(id);
        if (!sumTransition.getLabel().equals(label)) {
            throw new LabelMismatchException(sumTransition, sourceTransition);
        }
        return sumTransition;
    }

    private Place createOrGetPlace(Place sourcePlace) {
        if (!this.placeCache.containsKey(sourcePlace)) {
            Place sumPlace = this.sum.createPlace();
            sumPlace.setInitialToken(sourcePlace.getInitialToken());
            this.placeCache.put(sourcePlace, sumPlace);
            return sumPlace;
        }
        return this.placeCache.get(sourcePlace);
    }
}

