/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.snet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.snet.SNet;
import uniol.apt.analysis.snet.SNetResult;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class SNetModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "snet";
    }

    @Override
    public String getTitle() {
        return "S-Net";
    }

    @Override
    public String getShortDescription() {
        return "Check if a plain Petri net is an S-net";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". In a S-net, the preset and postset of any transition has at most one entry (plus the net is plain).";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", "plain");
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("s_net", Boolean.class, "success");
        outputSpec.addReturnValue("information", SNetResult.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        SNet snet = new SNet(pn);
        boolean returnValue = snet.testPlainSNet();
        SNetResult result = snet.getResult();
        output.setReturnValue("s_net", Boolean.class, returnValue);
        output.setReturnValue("information", SNetResult.class, result);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

