/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.snet;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Transition;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.analysis.snet.SNetResult;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class SNet {
    private final PetriNet petriNet;
    private SNetResult result;

    public SNet(PetriNet petriNet) {
        this.petriNet = petriNet;
        this.result = new SNetResult();
    }

    public boolean testPlainSNet() throws PreconditionFailedException {
        if (!new Plain().checkPlain(this.petriNet)) {
            throw new PreconditionFailedException("the net is not plain.");
        }
        for (Transition transition : this.petriNet.getTransitions()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (transition.getPreset().size() > 1) {
                this.result.addSynchronizationLabel(transition.getLabel());
                this.result.setSNet(false);
            }
            if (transition.getPostset().size() <= 1) continue;
            this.result.addSplittingLabel(transition.getLabel());
            this.result.setSNet(false);
        }
        return this.result.isSNet();
    }

    public SNetResult getResult() {
        return this.result;
    }
}

