/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.sideconditions;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.sideconditions.Pure;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PureModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "pure";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("pure", Boolean.class, "pure", "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        output.setReturnValue("pure", Boolean.class, Pure.checkPure(pn));
    }

    @Override
    public String getTitle() {
        return "Pure";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is pure";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A Petri net is pure if there are no side conditions. A side condition is a loop between a place p and a transition t (F(p,t)> 0 and F(t,p)>0).";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

