/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.sideconditions;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.sideconditions.NonPure;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class NonPureModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "nonpure";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("nonpure", Boolean.class, "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        boolean nonPure = false;
        nonPure = NonPure.checkNonPure(pn);
        output.setReturnValue("nonpure", Boolean.class, nonPure);
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is nonpure but only simple sideconditions";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A Petri net is nonpure when there exists atleast one self-loop. A sidecondition is simple, when both arcsof the self-loop have a weight of 1.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

