/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.sideconditions;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.sideconditions.CheckSideConditions;
import uniol.apt.analysis.sideconditions.SideConditions;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class CheckSideConditionsModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "sideconditions";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("side_conditions", SideConditions.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        SideConditions sideConditions = CheckSideConditions.checkSideConditions(pn);
        output.setReturnValue("side_conditions", SideConditions.class, sideConditions);
    }

    @Override
    public String getShortDescription() {
        return "Compute the sideconditions of a Petri net";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A side condition is a self-loop, consisting of the place, the transition and the arcs.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

