/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.sideconditions;

import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.analysis.sideconditions.SideCondition;
import uniol.apt.analysis.sideconditions.SideConditions;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class CheckSideConditions {
    private CheckSideConditions() {
    }

    public static SideConditions checkSideConditions(PetriNet pn) {
        SideConditions conditions = new SideConditions();
        for (Place p : pn.getPlaces()) {
            for (Flow a : p.getPostsetEdges()) {
                for (Flow b : p.getPresetEdges()) {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    if (!((Node)a.getTarget()).getId().equals(((Node)b.getSource()).getId())) continue;
                    conditions.add(new SideCondition(p, a.getTransition(), a, b));
                }
            }
        }
        return conditions;
    }
}

