/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.language.Word;
import uniol.apt.analysis.separation.Separation;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class WeakSeparationModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "weak_separation";
    }

    @Override
    public String getTitle() {
        return "Weak separation with respect to k (sequence)";
    }

    @Override
    public String getShortDescription() {
        return "Check if a given sequence is weakly k-separable";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ".\n\nExample calls:\n\nTo check a given firing sequence:\napt weak_separation petri_net.apt \"a1;a2;a3\"\n\nTo check a given firing sequence and set k to 2:\napt weak_separation petri_net.apt \"a1;a2;a3\" 2\n\nTo check a given firing sequence and set k to 2 with more output:\napt weak_separation petri_net.apt \"a1;a2;a3\" 2 verbose\n";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addParameter("sequence", Word.class, "Firing sequence which should be checked", new String[0]);
        inputSpec.addOptionalParameterWithDefault("k", Integer.class, 0, "0", "Value of k", new String[0]);
        inputSpec.addOptionalParameterWithDefault("verbose", String.class, "", "", "Optional more output", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("result", String.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        String returnValue = "";
        boolean verbose = false;
        Integer k = input.getParameter("k", Integer.class);
        if (k <= 0) {
            throw new ModuleException("k must be greater than zero.");
        }
        String stringVerbose = input.getParameter("verbose", String.class);
        if (stringVerbose.equals("verbose")) {
            verbose = true;
        }
        Word choosenFiringSequence = input.getParameter("sequence", Word.class);
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        Separation separation = new Separation(pn, true, (long)k.intValue(), choosenFiringSequence, verbose);
        returnValue = separation.getOutputLog();
        output.setReturnValue("result", String.class, returnValue);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

