/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uniol.apt.analysis.language.Word;

public class SeparationSingleResult {
    private boolean isSeparable_ = true;
    private boolean isStronglyCheck_;
    private long k;
    private Set<String> notExistingTransitions = new HashSet<String>();
    private boolean isNetUnbounded_ = false;
    private boolean testedJustASingleSequence;
    private ArrayList<String> testedSingleSequence;
    private String possibleWaySmallNetOrder;
    private int numberOfTestedSequences;
    private int lenghtOfTestedSequences;
    private ArrayList<String> notSeparableExampleSequence;

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        if (this.isNetUnbounded_) {
            sb.append("Error: Petri net is unbounded.");
        } else if (!this.notExistingTransitions.isEmpty()) {
            for (String notExistingTransition : this.notExistingTransitions) {
                sb.append("Warning: Transition " + notExistingTransition + " does not exist in Petri net.\n");
            }
        } else if (this.testedJustASingleSequence) {
            sb.append("The sequence " + SeparationSingleResult.outputFirableSequence(this.testedSingleSequence) + " is ");
            if (this.isStronglyCheck_) {
                if (this.isSeparable_) {
                    sb.append("strongly " + this.k + "-separable.\n");
                    sb.append("  e.g.: " + this.possibleWaySmallNetOrder + "\n");
                } else {
                    sb.append("not strongly " + this.k + "-separable.\n");
                }
            } else if (this.isSeparable_) {
                sb.append("weakly " + this.k + "-separable.\n");
            } else {
                sb.append("not weakly " + this.k + "-separable.\n");
            }
        } else if (this.isStronglyCheck_) {
            if (this.isSeparable_) {
                sb.append("All " + this.numberOfTestedSequences + " firing sequences up to length " + this.lenghtOfTestedSequences + " have been tested and found to be strongly " + this.k + "-separable.\n");
            } else {
                sb.append("The firing sequence " + SeparationSingleResult.outputFirableSequence(this.notSeparableExampleSequence) + " of length " + this.notSeparableExampleSequence.size() + " is not strongly " + this.k + "-separable.\n");
            }
        } else if (this.isSeparable_) {
            sb.append("All " + this.numberOfTestedSequences + " firing sequences up to length " + this.lenghtOfTestedSequences + " have been tested and found to be weakly " + this.k + "-separable.\n");
        } else {
            sb.append("The firing sequence " + SeparationSingleResult.outputFirableSequence(this.notSeparableExampleSequence) + " of length " + this.notSeparableExampleSequence.size() + " is not weakly " + this.k + "-separable.\n");
        }
        return sb.toString();
    }

    public static String outputFirableSequence(ArrayList<String> firableSequence) {
        return new Word((Collection<? extends String>)firableSequence).toString();
    }

    public Set<String> getNotExistingTransitions() {
        return this.notExistingTransitions;
    }

    public void addNotExistingTransition(String notExistingTransition) {
        this.notExistingTransitions.add(notExistingTransition);
    }

    public boolean isTestedJustASingleSequence() {
        return this.testedJustASingleSequence;
    }

    public void setTestedJustASingleSequence(boolean testedJustASingleSequence) {
        this.testedJustASingleSequence = testedJustASingleSequence;
    }

    public int getNumberOfTestedSequences() {
        return this.numberOfTestedSequences;
    }

    public void setNumberOfTestedSequences(int numberOfTestedSequences) {
        this.numberOfTestedSequences = numberOfTestedSequences;
    }

    public boolean isSeparable() {
        return this.isSeparable_;
    }

    public void setSeparable(boolean isSeparable) {
        this.isSeparable_ = isSeparable;
    }

    public ArrayList<String> getTestedSingleSequence() {
        return this.testedSingleSequence;
    }

    public void setTestedSingleSequence(ArrayList<String> testedSingleSequence) {
        this.testedSingleSequence = testedSingleSequence;
    }

    public String getPossibleWaySmallNetOrder() {
        return this.possibleWaySmallNetOrder;
    }

    public void setPossibleWaySmallNetOrder(String possibleWaySmallNetOrder) {
        this.possibleWaySmallNetOrder = possibleWaySmallNetOrder;
    }

    public boolean isNetUnbounded() {
        return this.isNetUnbounded_;
    }

    public void setNetUnbounded(boolean isNetUnbounded) {
        this.isNetUnbounded_ = isNetUnbounded;
    }

    public boolean isStronglyCheck() {
        return this.isStronglyCheck_;
    }

    public void setStronglyCheck(boolean isStronglyCheck) {
        this.isStronglyCheck_ = isStronglyCheck;
    }

    public long getK() {
        return this.k;
    }

    public void setK(long k) {
        this.k = k;
    }

    public int getLenghtOfTestedSequences() {
        return this.lenghtOfTestedSequences;
    }

    public void setLenghtOfTestedSequences(int lenghtOfTestedSequences) {
        this.lenghtOfTestedSequences = lenghtOfTestedSequences;
    }

    public ArrayList<String> getNotSeparableExampleSequence() {
        return this.notSeparableExampleSequence;
    }

    public void setNotSeparableExampleSequence(ArrayList<String> notSeparableExampleSequence) {
        this.notSeparableExampleSequence = notSeparableExampleSequence;
    }
}

