/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import java.util.ArrayList;
import uniol.apt.analysis.separation.SeparationSingleResult;

public class SeparationResult {
    private boolean separable = true;
    private ArrayList<SeparationSingleResult> singleResults = new ArrayList();
    private boolean isStronglyCheck_;
    private long kMax;
    private long k;
    private ArrayList<String> testedSequence;
    private boolean testedJustASingleSequence;
    private int maxLength;
    private boolean noMarks = false;
    private boolean kGreaterKMax = false;
    private boolean kNoDivisorOfKMax = false;
    private boolean noSequenceOfNet = false;
    private boolean noCounterExampleFound = false;

    public String toString() {
        StringBuilder sb = new StringBuilder("\n");
        if (this.testedJustASingleSequence) {
            if (this.noMarks) {
                sb.append("The initial marking is a k-marking, for every k>" + this.kMax + ".\n\nThe sequence " + SeparationSingleResult.outputFirableSequence(this.testedSequence));
                if (this.isStronglyCheck_) {
                    sb.append(" is strongly k-separable, for every k>=1.\n");
                } else {
                    sb.append(" is weakly k-separable, for every k>=1.\n");
                }
            } else if (this.kGreaterKMax) {
                sb.append("The initial marking is a " + this.kMax + "-marking but not an L-marking for any L>" + this.kMax + ".\nHowever, the chosen k=" + this.k + " is >" + this.kMax + ".");
            } else if (this.kNoDivisorOfKMax) {
                sb.append("The initial marking is a " + this.kMax + "-marking but not an L-marking for any L>" + this.kMax + ".\nk=" + this.k + " is not a divisor of " + this.kMax + ".");
            } else {
                sb.append("The initial marking is a " + this.kMax + "-marking but not an L-marking for any L>" + this.kMax + ".\n\n");
                if (this.noSequenceOfNet) {
                    sb.append("The sequence " + SeparationSingleResult.outputFirableSequence(this.testedSequence) + " is not a firing sequence of the Petri net.");
                } else {
                    for (SeparationSingleResult singleResult : this.singleResults) {
                        sb.append(singleResult.toString());
                    }
                    if (this.noCounterExampleFound) {
                        sb.append("\nThe sequence " + SeparationSingleResult.outputFirableSequence(this.testedSequence) + " is ");
                        if (this.isStronglyCheck_) {
                            sb.append("strongly d-separable, for any divisor d of " + this.k + ".\n");
                        } else {
                            sb.append("weakly d-separable, for any divisor d of " + this.k + ".\n");
                        }
                    }
                }
            }
        } else if (this.noMarks) {
            sb.append("The initial marking is a k-marking for every k>" + this.kMax + ".\n\nAll 1 firing sequence up to length " + this.maxLength);
            if (this.isStronglyCheck_) {
                sb.append(" have been tested and found to be strongly k-separable.\n");
            } else {
                sb.append(" have been tested and found to be weakly k-separable.\n");
            }
        } else if (this.kGreaterKMax) {
            sb.append("The initial marking is a " + this.kMax + "-marking but not an L-marking for any L>" + this.kMax + ".\nHowever, the chosen k=" + this.k + " is >" + this.kMax + ".");
        } else if (this.kNoDivisorOfKMax) {
            sb.append("The initial marking is a " + this.kMax + "-marking but not an L-marking for any L>" + this.kMax + ".\nk=" + this.k + " is not a divisor of " + this.kMax + ".");
        } else {
            sb.append("The initial marking is a " + this.kMax + "-marking but not an L-marking for any L>" + this.kMax + ".\n\n");
            for (SeparationSingleResult singleResult : this.singleResults) {
                sb.append(singleResult.toString());
            }
            if (this.noCounterExampleFound) {
                sb.append("\nAll firing sequences up to length " + this.maxLength + " have been tested and found to be ");
                if (this.isStronglyCheck_) {
                    sb.append("strongly d-separable, for any divisor d of " + this.k + ".\n");
                } else {
                    sb.append("weakly d-separable, for any divisor d of " + this.k + ".\n");
                }
            }
        }
        return sb.toString();
    }

    public boolean isNoMarks() {
        return this.noMarks;
    }

    public void setNoMarks(boolean noMarks) {
        this.noMarks = noMarks;
    }

    public boolean isSeparable() {
        return this.separable;
    }

    public void setSeparable(boolean separable) {
        this.separable = separable;
    }

    public long getkMax() {
        return this.kMax;
    }

    public void setkMax(long kMax) {
        this.kMax = kMax;
    }

    public long getK() {
        return this.k;
    }

    public void setK(long k) {
        this.k = k;
    }

    public boolean isStronglyCheck() {
        return this.isStronglyCheck_;
    }

    public void setStronglyCheck(boolean isStronglyCheck) {
        this.isStronglyCheck_ = isStronglyCheck;
    }

    public ArrayList<String> getTestedSequence() {
        return this.testedSequence;
    }

    public void setTestedSequence(ArrayList<String> testedSequence) {
        this.testedSequence = testedSequence;
    }

    public boolean iskGreaterKMax() {
        return this.kGreaterKMax;
    }

    public void setkGreaterKMax(boolean kGreaterKMax) {
        this.kGreaterKMax = kGreaterKMax;
    }

    public boolean iskNoDivisorOfKMax() {
        return this.kNoDivisorOfKMax;
    }

    public void setkNoDivisorOfKMax(boolean kNoDivisorOfKMax) {
        this.kNoDivisorOfKMax = kNoDivisorOfKMax;
    }

    public boolean isNoSequenceOfNet() {
        return this.noSequenceOfNet;
    }

    public void setNoSequenceOfNet(boolean noSequenceOfNet) {
        this.noSequenceOfNet = noSequenceOfNet;
    }

    public ArrayList<SeparationSingleResult> getSingleResults() {
        return this.singleResults;
    }

    public void addSingleResult(SeparationSingleResult singleResult) {
        this.singleResults.add(singleResult);
    }

    public boolean isNoCounterExampleFound() {
        return this.noCounterExampleFound;
    }

    public void setNoCounterExampleFound(boolean noCounterExampleFound) {
        this.noCounterExampleFound = noCounterExampleFound;
    }

    public boolean isTestedJustASingleSequence() {
        return this.testedJustASingleSequence;
    }

    public void setTestedJustASingleSequence(boolean testedJustASingleSequence) {
        this.testedJustASingleSequence = testedJustASingleSequence;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

