/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import java.util.ArrayList;
import java.util.HashSet;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.separation.FirableSequences;
import uniol.apt.analysis.separation.LargestK;
import uniol.apt.analysis.separation.SeparationSingleResult;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class SeparationLogic {
    private final PetriNet petriNet_;
    private final long k;
    private final int maxFiringSequenceLength;
    private ArrayList<ArrayList<String>> firableSequences;
    private ArrayList<ArrayList<String>> separatedFirableSequences;
    private SeparationSingleResult result;

    public SeparationLogic(PetriNet petriNet, boolean stronglyCheck, long initK, ArrayList<String> chosenFiringSequence, int maxLength, boolean fullOutput) throws UnboundedException {
        this.petriNet_ = petriNet;
        this.firableSequences = new ArrayList();
        this.maxFiringSequenceLength = chosenFiringSequence == null ? maxLength : chosenFiringSequence.size();
        LargestK kCalculator = new LargestK(petriNet);
        long kMax = kCalculator.computeLargestK();
        this.k = initK <= 0L ? kMax : initK;
        this.result = new SeparationSingleResult();
        this.result.setStronglyCheck(stronglyCheck);
        this.result.setK(this.k);
        this.result.setLenghtOfTestedSequences(maxLength);
        if (chosenFiringSequence != null) {
            HashSet<String> notExistingTransitions = new HashSet<String>();
            for (String chosenTransition : chosenFiringSequence) {
                boolean transitionIsInPetriNet = false;
                for (Transition transition : petriNet.getTransitions()) {
                    if (!chosenTransition.equals(transition.getId())) continue;
                    transitionIsInPetriNet = true;
                }
                if (transitionIsInPetriNet) continue;
                notExistingTransitions.add(chosenTransition);
            }
            if (!notExistingTransitions.isEmpty()) {
                for (String notExistingTransition : notExistingTransitions) {
                    this.result.addNotExistingTransition(notExistingTransition);
                }
                this.result.setSeparable(false);
                return;
            }
        }
        this.computeSeparation(chosenFiringSequence, stronglyCheck, fullOutput);
    }

    public final void computeSeparation(ArrayList<String> chosenFiringSequence, boolean stronglyCheck, boolean fullOutput) throws UnboundedException {
        if (chosenFiringSequence == null) {
            this.firableSequences = this.computeFireableSequences(this.petriNet_, false);
        }
        for (Place place : this.petriNet_.getPlaces()) {
            place.setInitialToken(place.getInitialToken().getValue() / this.k);
        }
        this.separatedFirableSequences = this.computeFireableSequences(this.petriNet_, true);
        for (Place place : this.petriNet_.getPlaces()) {
            place.setInitialToken(place.getInitialToken().getValue() * this.k);
        }
        if (chosenFiringSequence != null) {
            boolean outputSingleFiringSequence = true;
            this.checkSingleFiringSequence(chosenFiringSequence, stronglyCheck, outputSingleFiringSequence);
            this.result.setTestedJustASingleSequence(true);
            this.result.setNumberOfTestedSequences(1);
        } else {
            boolean outputSingleFiringSequence = fullOutput;
            for (ArrayList<String> firableSequence : this.firableSequences) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                this.checkSingleFiringSequence(firableSequence, stronglyCheck, outputSingleFiringSequence);
                if (fullOutput || this.result.isSeparable()) continue;
                break;
            }
            this.result.setTestedJustASingleSequence(false);
            this.result.setNumberOfTestedSequences(this.firableSequences.size() + 1);
        }
    }

    private void checkSingleFiringSequence(ArrayList<String> firableSequence, boolean stronglyCheck, boolean outputSingleFiringSequence) {
        boolean thisSequenceSeparable = true;
        FirableSequences firableSequencesOfM0 = new FirableSequences(this.separatedFirableSequences, this.k);
        if (stronglyCheck) {
            for (int i = 0; i < firableSequence.size(); ++i) {
                String wantedFire = firableSequence.get(i);
                if (firableSequencesOfM0.fire(wantedFire, true)) continue;
                thisSequenceSeparable = false;
            }
        } else {
            for (int i = 0; i < firableSequence.size(); ++i) {
                String wantedFire = firableSequence.get(i);
                if (firableSequencesOfM0.fire(wantedFire, false)) continue;
                thisSequenceSeparable = false;
            }
            if (!firableSequencesOfM0.isThereAValidFiringSequence()) {
                thisSequenceSeparable = false;
            }
        }
        if (this.result.isSeparable() && !thisSequenceSeparable) {
            this.result.setSeparable(false);
            this.result.setNotSeparableExampleSequence(firableSequence);
        }
        if (outputSingleFiringSequence) {
            this.result.setTestedSingleSequence(firableSequence);
            this.result.setPossibleWaySmallNetOrder(firableSequencesOfM0.getPossibleWaysSmallNetsOrderArray().get(0));
        }
    }

    private ArrayList<ArrayList<String>> computeFireableSequences(PetriNet petriNet, boolean onlyLongest) throws UnboundedException {
        ArrayList<ArrayList<String>> fireableSequences = new ArrayList<ArrayList<String>>();
        CoverabilityGraph coverability = CoverabilityGraph.get(petriNet);
        TransitionSystem coverabilityGraph = null;
        coverabilityGraph = coverability.toReachabilityLTS();
        if (this.maxFiringSequenceLength > 0) {
            for (Arc edge : coverabilityGraph.getInitialState().getPostsetEdges()) {
                ArrayList<String> prefix = new ArrayList<String>(0);
                this.computeFireableSequencesRecursiv(fireableSequences, edge, prefix, onlyLongest, 0);
            }
        }
        return fireableSequences;
    }

    private void computeFireableSequencesRecursiv(ArrayList<ArrayList<String>> fireableSequences, Arc edge, ArrayList<String> prefix, boolean onlyLongest, int actualLength) {
        InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
        ArrayList<String> prefixCopy = new ArrayList<String>(prefix);
        prefixCopy.add(edge.getLabel());
        ++actualLength;
        if (onlyLongest) {
            if (((State)edge.getTarget()).getPostsetEdges().isEmpty() || actualLength == this.maxFiringSequenceLength) {
                fireableSequences.add(prefixCopy);
            }
        } else if (fireableSequences.isEmpty()) {
            fireableSequences.add(prefixCopy);
        } else {
            boolean dataWritten = false;
            for (int i = 0; i < fireableSequences.size(); ++i) {
                if (dataWritten || fireableSequences.get(i).size() < prefixCopy.size()) continue;
                fireableSequences.add(i, prefixCopy);
                dataWritten = true;
            }
            if (!dataWritten) {
                fireableSequences.add(prefixCopy);
            }
        }
        if (actualLength < this.maxFiringSequenceLength) {
            for (Arc postEdge : ((State)edge.getTarget()).getPostsetEdges()) {
                this.computeFireableSequencesRecursiv(fireableSequences, postEdge, prefixCopy, onlyLongest, actualLength);
            }
        }
    }

    public SeparationSingleResult getResult() {
        return this.result;
    }
}

