/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import java.util.ArrayList;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.separation.LargestK;
import uniol.apt.analysis.separation.SeparationLogic;
import uniol.apt.analysis.separation.SeparationResult;

public class Separation {
    private SeparationResult result;

    public Separation(PetriNet petriNet, boolean stronglyCheck, long initK, ArrayList<String> chosenFiringSequence, boolean verbose) throws UnboundedException {
        LargestK kCalculator = new LargestK(petriNet);
        long kMax = kCalculator.computeLargestK();
        boolean foundNonSeparableExample = false;
        if (initK <= 0L) {
            initK = kMax;
        }
        this.result = new SeparationResult();
        this.result.setTestedJustASingleSequence(true);
        this.result.setStronglyCheck(stronglyCheck);
        this.result.setkMax(kMax);
        this.result.setK(initK);
        this.result.setTestedSequence(chosenFiringSequence);
        if (kMax == 0L) {
            this.result.setNoMarks(true);
            this.result.setSeparable(true);
        } else if (initK > kMax) {
            this.result.setkGreaterKMax(true);
            this.result.setSeparable(false);
        } else if (kMax % initK != 0L) {
            this.result.setkNoDivisorOfKMax(true);
            this.result.setSeparable(false);
        } else if (!Separation.isSequenceASequenceOfNet(petriNet, chosenFiringSequence)) {
            this.result.setNoSequenceOfNet(true);
            this.result.setSeparable(false);
        } else {
            for (long i = initK; i > 1L; --i) {
                if (initK % i != 0L) continue;
                SeparationLogic separation = new SeparationLogic(petriNet, stronglyCheck, i, chosenFiringSequence, 0, true);
                this.result.setSeparable(separation.getResult().isSeparable());
                this.result.addSingleResult(separation.getResult());
                if (this.result.isSeparable()) continue;
                if (verbose) {
                    foundNonSeparableExample = true;
                    continue;
                }
                return;
            }
            if (!foundNonSeparableExample) {
                this.result.setNoCounterExampleFound(true);
            }
        }
    }

    public Separation(PetriNet petriNet, boolean stronglyCheck, long initK, int maxLength, boolean verbose) throws UnboundedException {
        LargestK kCalculator = new LargestK(petriNet);
        long kMax = kCalculator.computeLargestK();
        boolean foundNonSeparableExample = false;
        if (initK == 0L) {
            initK = kMax;
        }
        this.result = new SeparationResult();
        this.result.setTestedJustASingleSequence(false);
        this.result.setMaxLength(maxLength);
        this.result.setkMax(kMax);
        this.result.setK(initK);
        if (kMax == 0L) {
            this.result.setNoMarks(true);
            this.result.setSeparable(true);
        } else if (initK > kMax) {
            this.result.setkGreaterKMax(true);
            this.result.setSeparable(false);
        } else if (kMax % initK != 0L) {
            this.result.setkNoDivisorOfKMax(true);
            this.result.setSeparable(false);
        } else {
            for (long i = initK; i > 1L; --i) {
                if (initK % i != 0L) continue;
                SeparationLogic separation = new SeparationLogic(petriNet, stronglyCheck, i, null, maxLength, false);
                this.result.setSeparable(separation.getResult().isSeparable());
                this.result.addSingleResult(separation.getResult());
                if (this.result.isSeparable()) continue;
                if (verbose) {
                    foundNonSeparableExample = true;
                    continue;
                }
                return;
            }
            if (!foundNonSeparableExample) {
                this.result.setNoCounterExampleFound(true);
            }
        }
    }

    public static boolean isSequenceASequenceOfNet(PetriNet petriNet, ArrayList<String> chosenFiringSequence) {
        CoverabilityGraph coverability = CoverabilityGraph.get(petriNet);
        TransitionSystem coverabilityGraph = null;
        coverabilityGraph = coverability.toCoverabilityLTS();
        State node = coverabilityGraph.getInitialState();
        for (String transition : chosenFiringSequence) {
            State nextNode = null;
            for (Arc edge : node.getPostsetEdges()) {
                if (!transition.equals(edge.getLabel())) continue;
                nextNode = (State)edge.getTarget();
            }
            if (nextNode == null) {
                return false;
            }
            node = nextNode;
        }
        return true;
    }

    public String getOutputLog() {
        return this.result.toString();
    }

    public boolean isSeparable() {
        return this.result.isSeparable();
    }
}

