/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.separation.LargestK;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class LargestKModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "k_marking";
    }

    @Override
    public String getTitle() {
        return "k-marking";
    }

    @Override
    public String getShortDescription() {
        return "Compute the largest k for which M0 is a k-marking";
    }

    @Override
    public String getLongDescription() {
        return "Compute the largest k for which M0 is a k-marking.\ne.g.: Output: Largest k for which M0 is a k-marking: 1";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("Largest k for which M0 is a k-marking", Long.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        LargestK largestK = new LargestK(pn);
        long returnValue = largestK.computeLargestK();
        output.setReturnValue("Largest k for which M0 is a k-marking", Long.class, returnValue);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

