/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import java.util.HashSet;
import java.util.Iterator;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class LargestK {
    private final PetriNet petriNet;

    public LargestK(PetriNet petriNet) {
        this.petriNet = petriNet;
    }

    public long computeGreatestCommonDivisor(long dividend, long divisor) {
        long lastDivisor = divisor;
        if (divisor == 0L || dividend == 0L) {
            return 0L;
        }
        while (divisor != 0L) {
            lastDivisor = divisor;
            divisor = dividend % divisor;
            dividend = lastDivisor;
        }
        return lastDivisor;
    }

    public long computeLargestK() {
        HashSet<Long> markValues = new HashSet<Long>();
        for (Place place : this.petriNet.getPlaces()) {
            long value = place.getInitialToken().getValue();
            if (value == 0L) continue;
            markValues.add(value);
        }
        long k = 0L;
        Iterator iterator = markValues.iterator();
        while (iterator.hasNext()) {
            long markValue = (Long)iterator.next();
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            if (k == 0L) {
                k = markValue;
                continue;
            }
            k = this.computeGreatestCommonDivisor(k, markValue);
        }
        return k;
    }
}

