/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.separation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class FirableSequences {
    private long k = 0L;
    private String magicWord = "u_s_e_d";
    private HashMap<Integer, ArrayList<ArrayList<String>>> firingSequencesMap = new HashMap();
    private int hashMapCounter = 0;
    private ArrayList<ArrayList<Integer>> possibleWaysFiringSequencesArray = new ArrayList(0);
    private ArrayList<String> possibleWaysSmallNetsOrderArray = new ArrayList(0);

    public FirableSequences(ArrayList<ArrayList<String>> initFirableSequences, long initK) {
        this.k = initK;
        ArrayList<Integer> possibleFiringSequences = new ArrayList<Integer>(0);
        ArrayList<ArrayList<String>> arrayListElement = new ArrayList<ArrayList<String>>(initFirableSequences);
        this.firingSequencesMap.put(this.hashMapCounter, arrayListElement);
        int i = 0;
        while ((long)i < this.k) {
            possibleFiringSequences.add(this.hashMapCounter);
            ++i;
        }
        ++this.hashMapCounter;
        this.possibleWaysFiringSequencesArray.add(possibleFiringSequences);
    }

    public ArrayList<String> getPossibleWaysSmallNetsOrderArray() {
        return this.possibleWaysSmallNetsOrderArray;
    }

    public boolean isFiringSequenceValid(ArrayList<String> firingSequence) {
        boolean usedAtBeginning = true;
        for (String singleTransition : firingSequence) {
            if (singleTransition != this.magicWord) {
                usedAtBeginning = false;
            }
            if (usedAtBeginning || !singleTransition.equals(this.magicWord)) continue;
            return false;
        }
        return true;
    }

    public boolean isThereAValidFiringSequence() {
        boolean isThereAValieFiringSequence = false;
        for (ArrayList<Integer> firingSequenceWay : this.possibleWaysFiringSequencesArray) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            boolean thisFiringSequenceWayOk = true;
            for (Integer firingSequencesKey : firingSequenceWay) {
                boolean thisSequencesOk = false;
                for (ArrayList<String> firingSequence : this.firingSequencesMap.get(firingSequencesKey)) {
                    thisSequencesOk |= this.isFiringSequenceValid(firingSequence);
                }
                thisFiringSequenceWayOk &= thisSequencesOk;
            }
            isThereAValieFiringSequence |= thisFiringSequenceWayOk;
        }
        return isThereAValieFiringSequence;
    }

    public boolean fire(String wantedFire, boolean checkStrongly) {
        ArrayList possibleWaysFiringSequencesArrayNext = new ArrayList(0);
        ArrayList<String> possibleWaysSmallNetsOrderArrayNext = new ArrayList<String>(0);
        HashSet<Integer> alreadyChecked = new HashSet<Integer>();
        int numberOfWays = this.possibleWaysFiringSequencesArray.size();
        for (int way = 0; way < numberOfWays; ++way) {
            alreadyChecked.clear();
            int kTimes = 0;
            while ((long)kTimes < this.k) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                int hashKeyToCheck = this.possibleWaysFiringSequencesArray.get(way).get(kTimes);
                ArrayList<Integer> possibleFiringSequences = new ArrayList<Integer>(0);
                if (!alreadyChecked.contains(hashKeyToCheck)) {
                    alreadyChecked.add(hashKeyToCheck);
                    boolean isThisSequencePossible = FirableSequences.checkIfWantedFireIsPossible(this.firingSequencesMap.get(hashKeyToCheck), wantedFire, checkStrongly);
                    if (isThisSequencePossible) {
                        int hashMapKey;
                        ArrayList<ArrayList<String>> nextFiringSequence = this.fireWanted(this.firingSequencesMap.get(hashKeyToCheck), wantedFire, checkStrongly);
                        int alreadyInHashMapKey = -1;
                        for (Map.Entry<Integer, ArrayList<ArrayList<String>>> entry : this.firingSequencesMap.entrySet()) {
                            if (!entry.getValue().equals(nextFiringSequence)) continue;
                            alreadyInHashMapKey = entry.getKey();
                        }
                        boolean hashMapKeyWritten = false;
                        if (alreadyInHashMapKey != -1) {
                            hashMapKey = alreadyInHashMapKey;
                        } else {
                            this.firingSequencesMap.put(this.hashMapCounter, nextFiringSequence);
                            hashMapKey = this.hashMapCounter++;
                        }
                        int copyK = 0;
                        while ((long)copyK < this.k) {
                            if (copyK != kTimes) {
                                int value = this.possibleWaysFiringSequencesArray.get(way).get(copyK);
                                if (!hashMapKeyWritten && hashMapKey > value) {
                                    possibleFiringSequences.add(hashMapKey);
                                    hashMapKeyWritten = true;
                                }
                                possibleFiringSequences.add(value);
                            }
                            ++copyK;
                        }
                        if (!hashMapKeyWritten) {
                            possibleFiringSequences.add(hashMapKey);
                        }
                        boolean newData = true;
                        for (ArrayList arrayList : possibleWaysFiringSequencesArrayNext) {
                            if (!arrayList.equals(possibleFiringSequences)) continue;
                            newData = false;
                        }
                        if (newData) {
                            String actualOrderPrefix;
                            if (this.possibleWaysSmallNetsOrderArray.isEmpty()) {
                                actualOrderPrefix = "Net" + String.valueOf(kTimes);
                            } else {
                                actualOrderPrefix = this.possibleWaysSmallNetsOrderArray.get(way);
                                actualOrderPrefix = actualOrderPrefix + ", Net" + String.valueOf(kTimes);
                            }
                            possibleWaysSmallNetsOrderArrayNext.add(actualOrderPrefix);
                            possibleWaysFiringSequencesArrayNext.add(possibleFiringSequences);
                        }
                    }
                }
                ++kTimes;
            }
        }
        this.possibleWaysSmallNetsOrderArray = possibleWaysSmallNetsOrderArrayNext;
        this.possibleWaysFiringSequencesArray = possibleWaysFiringSequencesArrayNext;
        return !this.possibleWaysFiringSequencesArray.isEmpty();
    }

    public ArrayList<ArrayList<String>> fireWanted(ArrayList<ArrayList<String>> possibleFiringSequence, String wantedFire, boolean checkStrongly) {
        ArrayList<ArrayList<String>> possibleFiringSequenceAfterWantedFire = new ArrayList<ArrayList<String>>();
        for (ArrayList<String> firingSequence : possibleFiringSequence) {
            ArrayList<String> newFiringSequence;
            if (checkStrongly) {
                if (!firingSequence.get(0).equals(wantedFire) || firingSequence.size() <= 1) continue;
                newFiringSequence = new ArrayList<String>(firingSequence);
                newFiringSequence.remove(0);
                possibleFiringSequenceAfterWantedFire.add(newFiringSequence);
                continue;
            }
            if (!firingSequence.contains(wantedFire)) continue;
            newFiringSequence = new ArrayList<String>(firingSequence);
            int index = firingSequence.indexOf(wantedFire);
            newFiringSequence.set(index, this.magicWord);
            possibleFiringSequenceAfterWantedFire.add(newFiringSequence);
        }
        return possibleFiringSequenceAfterWantedFire;
    }

    public static boolean checkIfWantedFireIsPossible(ArrayList<ArrayList<String>> possibleFiringSequence, String wantedFire, boolean checkStrongly) {
        for (ArrayList<String> firingSequence : possibleFiringSequence) {
            if (!(checkStrongly ? firingSequence.get(0).equals(wantedFire) : firingSequence.contains(wantedFire))) continue;
            return true;
        }
        return false;
    }
}

