/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.reversible;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.util.SpanningTree;

public class ReversibleTS {
    private final TransitionSystem ts;
    private final Set<State> unreversibleStates;

    public ReversibleTS(TransitionSystem ts) {
        this.ts = ts;
        SpanningTree forwardTree = SpanningTree.get(ts, ts.getInitialState());
        SpanningTree backwardTree = SpanningTree.getReversed(ts, ts.getInitialState());
        this.unreversibleStates = new HashSet<State>(ts.getNodes());
        this.unreversibleStates.removeAll(forwardTree.getUnreachableNodes());
        this.unreversibleStates.retainAll(backwardTree.getUnreachableNodes());
    }

    public final void check() {
    }

    public boolean check(String id) {
        State node = this.ts.getNode(id);
        return this.unreversibleStates.contains(node);
    }

    public Set<State> getUnreversibleStates() {
        return Collections.unmodifiableSet(this.unreversibleStates);
    }

    public boolean isReversible() {
        return this.unreversibleStates.isEmpty();
    }

    public State getNode() {
        if (this.unreversibleStates.isEmpty()) {
            return null;
        }
        return this.unreversibleStates.iterator().next();
    }
}

