/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.reversible;

import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.reversible.ReversibleTS;

public class ReversibleNet {
    private PetriNet pn_;
    private boolean reversible_ = false;
    private Marking marking_ = null;

    public ReversibleNet(PetriNet pn) {
        this.pn_ = pn;
    }

    public void check() throws UnboundedException {
        TransitionSystem ts = CoverabilityGraph.get(this.pn_).toReachabilityLTS();
        ReversibleTS ltsPersistent = new ReversibleTS(ts);
        ltsPersistent.check();
        this.reversible_ = ltsPersistent.isReversible();
        if (ltsPersistent.getNode() != null) {
            this.marking_ = (Marking)ltsPersistent.getNode().getExtension(Marking.class.getName());
        }
    }

    public boolean isReversible() {
        return this.reversible_;
    }

    public Marking getMarking() {
        return this.marking_;
    }
}

