/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.reversible;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.reversible.ReversibleNet;
import uniol.apt.analysis.reversible.ReversibleTS;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ReversibleModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "reversible";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn_or_ts", PetriNetOrTransitionSystem.class, "The Petri net or LTS that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("reversible", Boolean.class, "reversible", "success");
        outputSpec.addReturnValue("marking", Marking.class, new String[0]);
        outputSpec.addReturnValue("state", State.class, new String[0]);
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem pnOrTs = input.getParameter("pn_or_ts", PetriNetOrTransitionSystem.class);
        PetriNet pn = pnOrTs.getNet();
        TransitionSystem ts = pnOrTs.getTs();
        output.setReturnValue("marking", Marking.class, null);
        output.setReturnValue("state", State.class, null);
        if (pn != null) {
            ReversibleNet reversible = new ReversibleNet(pn);
            reversible.check();
            output.setReturnValue("reversible", Boolean.class, reversible.isReversible());
            output.setReturnValue("marking", Marking.class, reversible.getMarking());
        } else {
            ReversibleTS reversible = new ReversibleTS(ts);
            reversible.check();
            output.setReturnValue("reversible", Boolean.class, reversible.isReversible());
            output.setReturnValue("state", State.class, reversible.getNode());
        }
    }

    @Override
    public String getTitle() {
        return "Reversible";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net or LTS is reversible";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A LTS is reversible if every reachable state can reach the initial state again. A Petri net is reversible if its reachability graph is reversible.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN, Category.LTS};
    }
}

