/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.product;

import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.product.Product;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class ProductSyncModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "product_sync";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts1", TransitionSystem.class, "The first LTS of the product", new String[0]);
        inputSpec.addParameter("lts2", TransitionSystem.class, "The second LTS of the product", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("product", TransitionSystem.class, "raw", "file");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts1 = input.getParameter("lts1", TransitionSystem.class);
        TransitionSystem ts2 = input.getParameter("lts2", TransitionSystem.class);
        Product product = new Product(ts1, ts2);
        output.setReturnValue("product", TransitionSystem.class, product.getSyncProduct());
    }

    @Override
    public String getShortDescription() {
        return "Compute the synchronous product of two LTS";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

