/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.product;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class Product {
    private static final String EXTENSION_KEY_1 = "product_source_lts1_state";
    private static final String EXTENSION_KEY_2 = "product_source_lts2_state";
    private final TransitionSystem ts1;
    private final TransitionSystem ts2;
    private TransitionSystem result;
    private Map<Pair<State, State>, State> resultStateCache;
    private Queue<State> workQueue;

    public Product(TransitionSystem ts1, TransitionSystem ts2) {
        this.ts1 = ts1;
        this.ts2 = ts2;
    }

    public TransitionSystem getSyncProduct() {
        this.init();
        while (!this.workQueue.isEmpty()) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            State curr = this.workQueue.poll();
            State s1 = (State)curr.getExtension(EXTENSION_KEY_1);
            State s2 = (State)curr.getExtension(EXTENSION_KEY_2);
            for (Arc arc1 : s1.getPostsetEdges()) {
                State target1 = (State)arc1.getTarget();
                for (State target2 : s2.getPostsetNodesByLabel(arc1.getLabel())) {
                    State prod = this.createOrGetProductState(target1, target2);
                    this.result.createArc(curr, prod, arc1.getLabel());
                }
            }
        }
        return this.result;
    }

    public TransitionSystem getAsyncProduct() {
        this.init();
        while (!this.workQueue.isEmpty()) {
            State prod;
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            State curr = this.workQueue.poll();
            State s1 = (State)curr.getExtension(EXTENSION_KEY_1);
            State s2 = (State)curr.getExtension(EXTENSION_KEY_2);
            for (Arc arc1 : s1.getPostsetEdges()) {
                prod = this.createOrGetProductState((State)arc1.getTarget(), s2);
                this.result.createArc(curr, prod, arc1.getLabel());
            }
            for (Arc arc2 : s2.getPostsetEdges()) {
                prod = this.createOrGetProductState(s1, (State)arc2.getTarget());
                this.result.createArc(curr, prod, arc2.getLabel());
            }
        }
        return this.result;
    }

    private void init() {
        this.result = new TransitionSystem();
        this.resultStateCache = new HashMap<Pair<State, State>, State>();
        this.workQueue = new LinkedList<State>();
        State init = this.createOrGetProductState(this.ts1.getInitialState(), this.ts2.getInitialState());
        this.result.setInitialState(init);
    }

    private State createOrGetProductState(State s1, State s2) {
        Pair<State, State> statePair = new Pair<State, State>(s1, s2);
        if (this.resultStateCache.containsKey(statePair)) {
            return this.resultStateCache.get(statePair);
        }
        State state = this.result.createState();
        state.putExtension(EXTENSION_KEY_1, s1);
        state.putExtension(EXTENSION_KEY_2, s2);
        this.resultStateCache.put(statePair, state);
        this.workQueue.add(state);
        return state;
    }
}

