/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining.algebra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uniol.apt.analysis.processmining.algebra.ArrayMatrix;
import uniol.apt.analysis.processmining.algebra.Matrix;
import uniol.apt.analysis.processmining.algebra.MatrixMultiplication;
import uniol.apt.analysis.processmining.algebra.MatrixOperation;
import uniol.apt.analysis.processmining.algebra.MatrixOperationAddMultipleOf;
import uniol.apt.analysis.processmining.algebra.MatrixOperationInvert;
import uniol.apt.analysis.processmining.algebra.MatrixOperationSwap;
import uniol.apt.analysis.processmining.algebra.TransposedMatrix;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class SmithNormalForm {
    private final int rows;
    private final int columns;
    private final List<MatrixOperation> rowOperations = new ArrayList<MatrixOperation>();
    private final List<MatrixOperation> columnOperations = new ArrayList<MatrixOperation>();
    private final List<Integer> diagonalEntries = new ArrayList<Integer>();

    public SmithNormalForm(Matrix input) {
        this.rows = input.getRows();
        this.columns = input.getColumns();
        new Calculator(input);
    }

    public List<Integer> getDiagonalEntries() {
        return Collections.unmodifiableList(this.diagonalEntries);
    }

    public Matrix getLeftHandMatrixInverse() {
        Matrix result = ArrayMatrix.createIdentityMatrix(this.rows, this.rows);
        for (MatrixOperation op : this.rowOperations) {
            op.applyTo(result);
        }
        return result;
    }

    public Matrix getLeftHandMatrix() {
        Matrix result = ArrayMatrix.createIdentityMatrix(this.rows, this.rows);
        for (int index = this.rowOperations.size() - 1; index >= 0; --index) {
            this.rowOperations.get(index).reverseApplyTo(result);
        }
        return result;
    }

    public Matrix getRightHandMatrixInverse() {
        Matrix result = ArrayMatrix.createIdentityMatrix(this.columns, this.columns);
        Matrix transposed = TransposedMatrix.transpose(result);
        for (MatrixOperation op : this.columnOperations) {
            op.applyTo(transposed);
        }
        return result;
    }

    public Matrix getRightHandMatrix() {
        Matrix result = ArrayMatrix.createIdentityMatrix(this.columns, this.columns);
        Matrix transposed = TransposedMatrix.transpose(result);
        for (int index = this.columnOperations.size() - 1; index >= 0; --index) {
            this.columnOperations.get(index).reverseApplyTo(transposed);
        }
        return result;
    }

    private class Calculator {
        private final Matrix input;
        private final Matrix matrix;

        private Calculator(Matrix input) {
            this.input = input;
            this.matrix = new ArrayMatrix(input);
            this.testInvariants();
            DebugUtil.debug((Object)"Generating Smith normal form of ", (Object)this.matrix);
            this.diagonalise();
            this.orderDiagonalIncreasingly();
            int last = 0;
            for (int i = 0; i < Math.min(SmithNormalForm.this.rows, SmithNormalForm.this.columns); ++i) {
                int entry = this.matrix.get(i, i);
                SmithNormalForm.this.diagonalEntries.add(entry);
                assert (entry >= 0) : entry;
                assert (i == 0 || last == 0 && entry == 0 || last != 0 && entry % last == 0) : this.matrix;
                last = entry;
            }
            assert (this.isDiagonalMatrix(this.matrix));
            this.testInvariants();
        }

        private void diagonalise() {
            for (int i = 0; i < Math.min(SmithNormalForm.this.rows, SmithNormalForm.this.columns); ++i) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                do {
                    boolean reduced = true;
                    reduced &= this.reduceRow(i);
                    this.testInvariants();
                    this.testInvariants();
                    DebugUtil.debug((Object)"After reducing with i=", (Object)i, (Object)" once, the result is ", (Object)this.matrix);
                } while (!(reduced &= this.reduceColumn(i)));
            }
            DebugUtil.debug((Object)"Done with diagonalisation, result is ", (Object)this.matrix);
            assert (this.isDiagonalMatrix(this.matrix)) : this.matrix;
        }

        private void orderDiagonalIncreasingly() {
            assert (this.isDiagonalMatrix(this.matrix)) : this.matrix;
            for (int i = 0; i < Math.min(SmithNormalForm.this.rows, SmithNormalForm.this.columns) - 1; ++i) {
                this.orderSuccessiveDiagonalEntries(i);
                if (this.matrix.get(i, i) < 0) {
                    this.invertRow(i);
                }
                this.testInvariants();
                if (i <= 0) continue;
                int previousEntry = this.matrix.get(i - 1, i - 1);
                int thisEntry = this.matrix.get(i, i);
                if (previousEntry == 0 || thisEntry % previousEntry == 0) continue;
                DebugUtil.debug("Re-examining previous diagonal entry");
                i -= 2;
            }
            int lastDiagonalEntry = Math.min(SmithNormalForm.this.rows, SmithNormalForm.this.columns) - 1;
            if (this.matrix.get(lastDiagonalEntry, lastDiagonalEntry) < 0) {
                this.invertRow(lastDiagonalEntry);
            }
            DebugUtil.debug((Object)"After cleaning up the diagonal: ", (Object)this.matrix);
            assert (this.isDiagonalMatrix(this.matrix));
            this.testInvariants();
        }

        private void orderSuccessiveDiagonalEntries(int i) {
            block0: while (true) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                int entry = this.matrix.get(i, i);
                int nextEntry = this.matrix.get(i + 1, i + 1);
                DebugUtil.debugFormat("Entry (%d,%d) = %d and next one is (%d,%d)=%d", i, i, entry, i + 1, i + 1, nextEntry);
                if (nextEntry != 0 && Math.abs(nextEntry) < Math.abs(entry)) {
                    int tmp = entry;
                    entry = nextEntry;
                    nextEntry = tmp;
                    DebugUtil.debug("Swapping (absolutely) smaller value up");
                    this.swapRows(i, i + 1);
                    this.swapColumns(i, i + 1);
                }
                if (entry == 0 || nextEntry % entry == 0) {
                    return;
                }
                DebugUtil.debug("Trying to construct GCD/LCM of these entries");
                this.addMultipleToRow(i + 1, i, 1);
                boolean done = false;
                while (true) {
                    if (done) continue block0;
                    done = true;
                    done &= this.reduceRow(i);
                    DebugUtil.debug((Object)"After reducing row ", (Object)i, (Object)" again: ", (Object)this.matrix);
                    done &= this.reduceColumn(i);
                    DebugUtil.debug((Object)"After also reducing column ", (Object)i, (Object)" again: ", (Object)this.matrix);
                }
                break;
            }
        }

        private boolean reduceRow(int row) {
            return this.reduce(row, false);
        }

        private boolean reduceColumn(int row) {
            return this.reduce(row, true);
        }

        private boolean reduce(int row, boolean swapped) {
            Integer pivotColumn;
            boolean didNothingInLastLoop;
            DebugUtil.debugFormat("Reducing row %d of %s%s", row, this.matrix, swapped ? " (swapped)" : "");
            boolean didNothing = true;
            Matrix state = swapped ? TransposedMatrix.transpose(this.matrix) : this.matrix;
            do {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                didNothingInLastLoop = true;
                pivotColumn = this.findPivotInRow(state, row);
                DebugUtil.debugFormat("Pivot column is %s", pivotColumn);
                if (pivotColumn == null) {
                    assert (didNothing);
                    return true;
                }
                boolean didSomething = false;
                int pivotEntry = state.get(row, pivotColumn);
                assert (pivotEntry != 0);
                for (int column = 0; column < state.getColumns(); ++column) {
                    int entry;
                    int factor;
                    if (column == pivotColumn || (factor = -(entry = state.get(row, column)) / pivotEntry) == 0) continue;
                    didNothingInLastLoop = false;
                    didNothing = false;
                    if (!swapped) {
                        this.addMultipleToColumn(pivotColumn, column, factor);
                        continue;
                    }
                    this.addMultipleToRow(pivotColumn, column, factor);
                }
            } while (!didNothingInLastLoop);
            if (pivotColumn != row) {
                didNothing = false;
                if (!swapped) {
                    this.swapColumns(pivotColumn, row);
                } else {
                    this.swapRows(pivotColumn, row);
                }
            }
            DebugUtil.debugFormat("Reduction done%s", didNothing ? " (nothing was done)" : "");
            return didNothing;
        }

        private Integer findPivotInRow(Matrix matrix, int row) {
            Integer result = null;
            int resultEntry = 0;
            for (int column = 0; column < matrix.getColumns(); ++column) {
                int entry = matrix.get(row, column);
                if (entry == Integer.MIN_VALUE) {
                    throw new ArithmeticException("Calculated Integer.MIN_VALUE, integer underflow will occur");
                }
                if (entry == 0 || result != null && Math.abs(entry) >= Math.abs(resultEntry)) continue;
                result = column;
                resultEntry = entry;
            }
            return result;
        }

        private void addMultipleToRow(int rowToAdd, int rowToAddTo, int factor) {
            this.doRowOperation(new MatrixOperationAddMultipleOf(rowToAdd, rowToAddTo, factor));
        }

        private void addMultipleToColumn(int columnToAdd, int columnToAddTo, int factor) {
            this.doColumnOperation(new MatrixOperationAddMultipleOf(columnToAdd, columnToAddTo, factor));
        }

        private void invertRow(int row) {
            this.doRowOperation(new MatrixOperationInvert(row));
        }

        private void swapRows(int firstRow, int secondRow) {
            this.doRowOperation(new MatrixOperationSwap(firstRow, secondRow));
        }

        private void swapColumns(int firstColumn, int secondColumn) {
            this.doColumnOperation(new MatrixOperationSwap(firstColumn, secondColumn));
        }

        private void doRowOperation(MatrixOperation operation) {
            SmithNormalForm.this.rowOperations.add(operation);
            operation.applyTo(this.matrix);
        }

        private void doColumnOperation(MatrixOperation operation) {
            SmithNormalForm.this.columnOperations.add(operation);
            operation.applyTo(TransposedMatrix.transpose(this.matrix));
        }

        private void testInvariants() {
            assert (MatrixMultiplication.multiply(SmithNormalForm.this.getLeftHandMatrix(), SmithNormalForm.this.getLeftHandMatrixInverse()).equals(ArrayMatrix.createIdentityMatrix(SmithNormalForm.this.rows, SmithNormalForm.this.rows)));
            assert (MatrixMultiplication.multiply(SmithNormalForm.this.getRightHandMatrix(), SmithNormalForm.this.getRightHandMatrixInverse()).equals(ArrayMatrix.createIdentityMatrix(SmithNormalForm.this.columns, SmithNormalForm.this.columns)));
            assert (MatrixMultiplication.multiply(SmithNormalForm.this.getLeftHandMatrix(), this.matrix, SmithNormalForm.this.getRightHandMatrix()).equals(this.input));
            assert (MatrixMultiplication.multiply(SmithNormalForm.this.getLeftHandMatrixInverse(), this.input, SmithNormalForm.this.getRightHandMatrixInverse()).equals(this.matrix));
        }

        private boolean isDiagonalMatrix(Matrix matrix) {
            for (int row = 0; row < matrix.getRows(); ++row) {
                for (int column = 0; column < matrix.getColumns(); ++column) {
                    if (row == column || matrix.get(row, column) == 0) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

