/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining.algebra;

import uniol.apt.analysis.processmining.algebra.Matrix;
import uniol.apt.analysis.processmining.algebra.MatrixOperation;

class MatrixOperationAddMultipleOf
implements MatrixOperation {
    private final int rowToAdd;
    private final int rowToAddTo;
    private final int factor;

    public MatrixOperationAddMultipleOf(int rowToAdd, int rowToAddTo, int factor) {
        assert (rowToAdd != rowToAddTo);
        this.rowToAdd = rowToAdd;
        this.rowToAddTo = rowToAddTo;
        this.factor = factor;
    }

    @Override
    public void applyTo(Matrix matrix) {
        MatrixOperationAddMultipleOf.addMultipleToRow(matrix, this.rowToAdd, this.rowToAddTo, this.factor);
    }

    @Override
    public void reverseApplyTo(Matrix matrix) {
        MatrixOperationAddMultipleOf.addMultipleToRow(matrix, this.rowToAdd, this.rowToAddTo, -this.factor);
    }

    private static void addMultipleToRow(Matrix matrix, int rowToAdd, int rowToAddTo, int factor) {
        for (int column = 0; column < matrix.getColumns(); ++column) {
            int entryAdd = matrix.get(rowToAdd, column);
            int entryAddTo = matrix.get(rowToAddTo, column);
            matrix.set(rowToAddTo, column, entryAddTo + factor * entryAdd);
        }
    }
}

