/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining.algebra;

import uniol.apt.analysis.processmining.algebra.AbstractMatrix;
import uniol.apt.analysis.processmining.algebra.Matrix;

public class MatrixMultiplication
extends AbstractMatrix
implements Matrix {
    private final Matrix lhs;
    private final Matrix rhs;

    private MatrixMultiplication(Matrix lhs, Matrix rhs) {
        if (lhs.getColumns() != rhs.getRows()) {
            throw new IllegalArgumentException();
        }
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public int getColumns() {
        return this.rhs.getColumns();
    }

    @Override
    public int getRows() {
        return this.lhs.getRows();
    }

    @Override
    public int get(int row, int column) {
        int result = 0;
        for (int i = 0; i < this.lhs.getColumns(); ++i) {
            result += this.lhs.get(row, i) * this.rhs.get(i, column);
        }
        return result;
    }

    @Override
    public void set(int row, int column, int value) {
        throw new UnsupportedOperationException();
    }

    public static Matrix multiply(Matrix first, Matrix ... other) {
        Matrix result = first;
        for (Matrix matrix : other) {
            result = new MatrixMultiplication(result, matrix);
        }
        return result;
    }
}

