/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining.algebra;

import uniol.apt.analysis.processmining.algebra.AbstractMatrix;
import uniol.apt.analysis.processmining.algebra.Matrix;

public class ArrayMatrix
extends AbstractMatrix
implements Matrix {
    private final int[][] elements;

    public ArrayMatrix(Matrix matrix) {
        int rows = matrix.getRows();
        int columns = matrix.getColumns();
        this.elements = new int[rows][];
        for (int row = 0; row < rows; ++row) {
            this.elements[row] = new int[columns];
            for (int column = 0; column < columns; ++column) {
                this.elements[row][column] = matrix.get(row, column);
            }
        }
    }

    private ArrayMatrix(int[][] elements) {
        this.elements = elements;
    }

    @Override
    public int getColumns() {
        return this.elements[0].length;
    }

    @Override
    public int getRows() {
        return this.elements.length;
    }

    @Override
    public int get(int row, int column) {
        return this.elements[row][column];
    }

    @Override
    public void set(int row, int column, int value) {
        this.elements[row][column] = value;
    }

    public static Matrix createIdentityMatrix(int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new IllegalArgumentException();
        }
        int[][] elements = new int[rows][];
        for (int row = 0; row < rows; ++row) {
            elements[row] = new int[columns];
            if (row >= columns) continue;
            elements[row][row] = 1;
        }
        return new ArrayMatrix(elements);
    }
}

