/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining.algebra;

import uniol.apt.analysis.processmining.algebra.Matrix;

public abstract class AbstractMatrix
implements Matrix {
    public int hashCode() {
        int result = this.getRows() << 16 | this.getColumns();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getColumns(); ++column) {
                int value = this.get(row, column);
                result = (result << 7) + 11 * (result >> 25) + value;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix other = (Matrix)o;
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getColumns() != other.getColumns()) {
            return false;
        }
        for (int row = 0; row < this.getRows(); ++row) {
            for (int column = 0; column < this.getColumns(); ++column) {
                if (this.get(row, column) == other.get(row, column)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        int rows = this.getRows();
        int columns = this.getColumns();
        StringBuilder builder = new StringBuilder("[");
        for (int row = 0; row < rows; ++row) {
            builder.append("[");
            for (int column = 0; column < columns; ++column) {
                if (column != 0) {
                    builder.append(", ");
                }
                builder.append(this.get(row, column));
            }
            builder.append("]");
        }
        builder.append("]");
        return builder.toString();
    }
}

