/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.Transformer;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.analysis.processmining.algebra.ArrayMatrix;
import uniol.apt.analysis.processmining.algebra.Matrix;
import uniol.apt.analysis.processmining.algebra.SmithNormalForm;
import uniol.apt.util.DebugUtil;

public class InvariantsMapper
implements Transformer<ParikhVector, List<Integer>> {
    private final List<String> alphabetList;
    private final List<List<Integer>> newEventWeights = new ArrayList<List<Integer>>();

    public InvariantsMapper(Set<String> alphabet, Collection<List<String>> invariantWords) {
        List<Object> diagonals;
        Matrix transformation;
        this.alphabetList = new ArrayList<String>(alphabet);
        if (this.alphabetList.isEmpty()) {
            return;
        }
        HashSet<ParikhVector> invariants = new HashSet<ParikhVector>();
        for (List<String> word : invariantWords) {
            ParikhVector wordPV = new ParikhVector(word);
            invariants.add(wordPV);
            if (alphabet.containsAll(wordPV.getLabels())) continue;
            throw new IllegalArgumentException();
        }
        if (invariants.isEmpty()) {
            DebugUtil.debug("No invariants giving, using identity mapping");
            transformation = ArrayMatrix.createIdentityMatrix(this.alphabetList.size(), this.alphabetList.size());
            diagonals = Collections.emptyList();
        } else {
            Matrix matrix = ArrayMatrix.createIdentityMatrix(this.alphabetList.size(), invariants.size());
            int invariantNumber = 0;
            for (ParikhVector invariant : invariants) {
                int eventNumber = 0;
                for (String event : this.alphabetList) {
                    matrix.set(eventNumber, invariantNumber, invariant.get(event));
                    ++eventNumber;
                }
                ++invariantNumber;
            }
            SmithNormalForm nf = new SmithNormalForm(matrix);
            transformation = nf.getLeftHandMatrixInverse();
            diagonals = nf.getDiagonalEntries();
            DebugUtil.debugFormat("Calculated smith normal form: %s*(%s)*%s", nf.getLeftHandMatrix(), diagonals, nf.getRightHandMatrix());
            DebugUtil.debugFormat("Inverse matrices are %s and %s", nf.getLeftHandMatrixInverse(), nf.getRightHandMatrixInverse());
        }
        for (int index = 0; index < this.alphabetList.size(); ++index) {
            int diag;
            int n = diag = index < diagonals.size() ? (Integer)diagonals.get(index) : 0;
            if (diag != 0) continue;
            ArrayList<Integer> weights = new ArrayList<Integer>();
            int eventIndex = 0;
            for (String event : this.alphabetList) {
                weights.add(transformation.get(index, eventIndex));
                ++eventIndex;
            }
            this.newEventWeights.add(weights);
            DebugUtil.debugFormat("New event e_%d has weights %s in %s", index, weights, this.alphabetList);
        }
    }

    @Override
    public List<Integer> transform(ParikhVector pv) {
        if (!this.alphabetList.containsAll(pv.getLabels())) {
            throw new IllegalArgumentException();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (List<Integer> eventWeights : this.newEventWeights) {
            int count = 0;
            for (int index = 0; index < this.alphabetList.size(); ++index) {
                count += eventWeights.get(index) * pv.get(this.alphabetList.get(index));
            }
            result.add(count);
        }
        return result;
    }
}

