/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.language.Word;
import uniol.apt.analysis.language.WordList;
import uniol.apt.analysis.processmining.CreateLTS;
import uniol.apt.analysis.processmining.InvariantsMapper;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class CreateLTSModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Create an LTS from a list of words";
    }

    @Override
    public String getName() {
        return "create_lts";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("words", WordList.class, "The list of words that should be possible", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("invariants", WordList.class, "The list of invariants that should be honored", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("lts", TransitionSystem.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        CreateLTS create;
        WordList words = input.getParameter("words", WordList.class);
        WordList invariants = input.getParameter("invariants", WordList.class);
        if (invariants == null) {
            create = new CreateLTS();
        } else {
            HashSet alphabet = new HashSet();
            for (Object word : words) {
                alphabet.addAll(word);
            }
            ArrayList<List<String>> invariantCollection = new ArrayList<List<String>>();
            for (Word word : invariants) {
                invariantCollection.add(new ArrayList<String>(word));
                alphabet.addAll(word);
            }
            InvariantsMapper mapper = new InvariantsMapper(alphabet, invariantCollection);
            create = new CreateLTS(mapper);
        }
        for (Word word : words) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            create.addWord(word);
        }
        TransitionSystem result = create.getTransitionSystem();
        output.setReturnValue("lts", TransitionSystem.class, result);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

