/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.processmining;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import uniol.apt.adt.ts.ParikhVector;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;

public class CreateLTS {
    private final TransitionSystem ts = new TransitionSystem();
    private final Map<Object, State> stateMap = new HashMap<Object, State>();
    private final Transformer<ParikhVector, ? extends Object> transformer;
    private static final Transformer<ParikhVector, ?> NOP_TRANSFORMER = TransformerUtils.nopTransformer();

    public CreateLTS() {
        this(NOP_TRANSFORMER);
    }

    public CreateLTS(Transformer<ParikhVector, ? extends Object> transformer) {
        this.transformer = transformer;
        this.ts.setInitialState(this.findOrCreateState(new ParikhVector(new String[0])));
    }

    private State findOrCreateState(ParikhVector pv) {
        Object transformedValue = this.transformer.transform(pv);
        State result = this.stateMap.get(transformedValue);
        if (result == null) {
            result = this.ts.createState();
            this.stateMap.put(transformedValue, result);
        }
        return result;
    }

    public void addWord(List<String> word) {
        ParikhVector pv = new ParikhVector(new String[0]);
        State lastState = this.ts.getInitialState();
        for (String event : word) {
            pv = pv.add(event);
            State state = this.findOrCreateState(pv);
            if (!lastState.getPostsetNodesByLabel(event).contains(state)) {
                this.ts.createArc(lastState, state, event);
            }
            lastState = state;
        }
    }

    public TransitionSystem getTransitionSystem() {
        return new TransitionSystem(this.ts);
    }
}

