/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.presynthesis.pps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.presynthesis.pps.DfsPathIterable;
import uniol.apt.analysis.presynthesis.pps.Path;
import uniol.apt.analysis.presynthesis.pps.PpsPropertyResult;
import uniol.apt.util.Pair;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class PpsPropertyChecker {
    private PpsPropertyResult result;

    public PpsPropertyResult getResult() {
        return this.result;
    }

    public boolean hasProperties(TransitionSystem ts) {
        return this.hasPropertyB(ts) && this.hasPropertyD(ts) && this.hasPropertyF(ts, ts.getNodes().size() * 2);
    }

    public boolean hasPropertyB(TransitionSystem ts) {
        for (State s : ts.getNodes()) {
            if (this.hasPropertyB(s)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPropertyB(State s) {
        ArrayList<Arc> preset = new ArrayList<Arc>(s.getPresetEdges());
        for (int i = 0; i < preset.size(); ++i) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            for (int j = i + 1; j < preset.size(); ++j) {
                boolean aToMQuoteQuote;
                Arc a = (Arc)preset.get(i);
                Arc b = (Arc)preset.get(j);
                boolean bToMQuote = !((State)a.getSource()).getPresetEdgesByLabel(b.getLabel()).isEmpty();
                boolean bl = aToMQuoteQuote = !((State)b.getSource()).getPresetEdgesByLabel(a.getLabel()).isEmpty();
                if (bToMQuote == aToMQuoteQuote) continue;
                this.result = new PpsPropertyResult("B");
                this.result.getOffendingStates().put("M", s);
                this.result.getTransitions().put("a", a.getLabel());
                this.result.getTransitions().put("b", b.getLabel());
                return false;
            }
        }
        return true;
    }

    public boolean hasPropertyD(TransitionSystem ts) {
        HashSet<Pair<String, String>> labelsToCheck = new HashSet<Pair<String, String>>();
        for (State state : ts.getNodes()) {
            labelsToCheck.addAll(this.getPostsetLabelPairs(state));
        }
        for (Pair pair : labelsToCheck) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            List<String> ab = Arrays.asList((String)pair.getFirst(), (String)pair.getSecond());
            List<String> ba = Arrays.asList((String)pair.getSecond(), (String)pair.getFirst());
            for (State sk : ts.getNodes()) {
                Set<State> kab = this.getSequenceDestinations(sk, ab);
                Set<State> kba = this.getSequenceDestinations(sk, ba);
                if (kab.isEmpty() == kba.isEmpty()) continue;
                this.result = new PpsPropertyResult("D");
                this.result.getOffendingStates().put("K", sk);
                this.result.getTransitions().put("a", (String)pair.getFirst());
                this.result.getTransitions().put("b", (String)pair.getSecond());
                return false;
            }
        }
        return true;
    }

    public boolean hasPropertyF(TransitionSystem ts, int maxPathLength) {
        for (State s : ts.getNodes()) {
            if (this.hasPropertyF(s, maxPathLength)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPropertyF(State s, int maxPathLength) {
        for (Path w : new DfsPathIterable(s, maxPathLength)) {
            for (Path v : new DfsPathIterable(s, maxPathLength)) {
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                HashSet<Arc> postTargetW = new HashSet<Arc>(w.getTarget().getPostsetEdges());
                Set<Arc> postTargetV = v.getTarget().getPostsetEdges();
                HashSet<String> candidatesC = new HashSet<String>(this.arcToLabels(postTargetW));
                candidatesC.retainAll(this.arcToLabels(postTargetV));
                if (candidatesC.isEmpty()) continue;
                List<String> labelsW = w.getLabels();
                List<String> labelsV = v.getLabels();
                Set<State> seqTargetsVW = this.getSequenceDestinations(v.getTarget(), labelsW);
                Set<State> seqTargetsWV = this.getSequenceDestinations(w.getTarget(), labelsV);
                if (seqTargetsVW.isEmpty() || seqTargetsWV.isEmpty()) continue;
                String lastC = null;
                for (String c : candidatesC) {
                    if (s.getPostsetEdgesByLabel(c).isEmpty()) continue;
                    for (State svw : seqTargetsVW) {
                        for (State swv : seqTargetsWV) {
                            HashSet<State> sQuoteCandidatesVW = new HashSet<State>(svw.getPostsetNodesByLabel(c));
                            Set<State> sQuoteCandidatesWV = swv.getPostsetNodesByLabel(c);
                            sQuoteCandidatesVW.retainAll(sQuoteCandidatesWV);
                            if (sQuoteCandidatesVW.isEmpty()) continue;
                            return true;
                        }
                    }
                    lastC = c;
                }
                this.result = new PpsPropertyResult("F");
                this.result.getOffendingStates().put("M", s);
                this.result.getTransitions().put("v", labelsV.toString());
                this.result.getTransitions().put("w", labelsW.toString());
                this.result.getTransitions().put("c", lastC);
                return false;
            }
        }
        return true;
    }

    private Set<String> arcToLabels(Set<Arc> arcs) {
        HashSet<String> labels = new HashSet<String>();
        for (Arc arc : arcs) {
            labels.add(arc.getLabel());
        }
        return labels;
    }

    private Set<Pair<String, String>> getPostsetLabelPairs(State s) {
        HashSet<Pair<String, String>> pairs = new HashSet<Pair<String, String>>();
        ArrayList<Arc> postset = new ArrayList<Arc>(s.getPostsetEdges());
        for (int i = 0; i < postset.size(); ++i) {
            for (int j = i + 1; j < postset.size(); ++j) {
                Arc a = (Arc)postset.get(i);
                Arc b = (Arc)postset.get(j);
                pairs.add(new Pair<String, String>(a.getLabel(), b.getLabel()));
            }
        }
        return pairs;
    }

    private Set<State> getSequenceDestinations(State origin, List<String> labels) {
        if (labels.isEmpty()) {
            return Collections.emptySet();
        }
        if (labels.size() == 1) {
            return origin.getPostsetNodesByLabel(labels.get(0));
        }
        HashSet<State> result = new HashSet<State>();
        Set<State> postset = origin.getPostsetNodesByLabel(labels.get(0));
        for (State s : postset) {
            LinkedList<String> tail = new LinkedList<String>(labels);
            tail.remove(0);
            result.addAll(this.getSequenceDestinations(s, tail));
        }
        return result;
    }
}

