/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.presynthesis.pps;

import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.presynthesis.pps.PpsPropertyChecker;
import uniol.apt.analysis.presynthesis.pps.PpsPropertyResult;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PpsPresynthesisModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getShortDescription() {
        return "Performs pps-presynthesis checks on a transition system";
    }

    @Override
    public String getLongDescription() {
        return "Checks if it is infeasible to synthesize a plain, pure and safe Petri net from the given transition system. The following properties are checked:\n\n(B) If M'[a>M and M''[b>M then [b>M' <=> [a>M''\n(D) If M[a> and M[b> then for any K: (K[ab> <=> K[ba>)\n(F) If M[wv> and M[vw> and M[wc> and M[vc> then M[wvc>M' and M[vwc>M' and M[c>\n\n  with transitions a, b, c and sequences v, w.";
    }

    @Override
    public String getName() {
        return "ppspresynthesis";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "Input LTS", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("infeasible", Boolean.class, "success");
        outputSpec.addReturnValue("violatedProperty", PpsPropertyResult.class, "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PpsPropertyChecker ppsChecker = new PpsPropertyChecker();
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        if (!ppsChecker.hasProperties(ts)) {
            output.setReturnValue("infeasible", Boolean.class, true);
            output.setReturnValue("violatedProperty", PpsPropertyResult.class, ppsChecker.getResult());
        }
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

