/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.presynthesis.pps;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.analysis.presynthesis.pps.Path;
import uniol.apt.util.Pair;

public class DfsPathIterable
implements Iterable<Path> {
    private final int maxPathLength;
    private final State origin;

    public DfsPathIterable(State origin, int maxPathLength) {
        this.maxPathLength = maxPathLength;
        this.origin = origin;
    }

    @Override
    public Iterator<Path> iterator() {
        return new DfsPathIterator();
    }

    private class DfsPathIterator
    implements Iterator<Path> {
        private final Deque<Pair<State, List<Arc>>> dfsStack = new LinkedList<Pair<State, List<Arc>>>();

        private DfsPathIterator() {
            this.addStateToStack(DfsPathIterable.this.origin);
        }

        @Override
        public boolean hasNext() {
            for (Pair<State, List<Arc>> elem : this.dfsStack) {
                List<Arc> arcs = elem.getSecond();
                if (arcs.size() <= 1 && (elem != this.dfsStack.getLast() || arcs.size() <= 0)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Path next() {
            while (!this.dfsStack.isEmpty()) {
                List<Arc> remArcs;
                Pair<State, List<Arc>> elem = this.dfsStack.getLast();
                List<Arc> arcs = elem.getSecond();
                if (!arcs.isEmpty() && this.dfsStack.size() <= DfsPathIterable.this.maxPathLength) {
                    Path result = this.stackToPath();
                    Arc next = arcs.get(0);
                    this.addStateToStack((State)next.getTarget());
                    return result;
                }
                this.dfsStack.removeLast();
                if (this.dfsStack.isEmpty() || (remArcs = this.dfsStack.getLast().getSecond()).isEmpty()) continue;
                remArcs.remove(0);
            }
            assert (!this.hasNext());
            throw new IllegalStateException("Iterator is exhausted but next was called.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void addStateToStack(State state) {
            LinkedList<Arc> arcs = new LinkedList<Arc>(state.getPostsetEdges());
            this.dfsStack.addLast(new Pair<State, LinkedList<Arc>>(state, arcs));
        }

        private Path stackToPath() {
            ArrayList<Arc> path = new ArrayList<Arc>();
            for (Pair<State, List<Arc>> elem : this.dfsStack) {
                Arc nextPathArc = elem.getSecond().get(0);
                path.add(nextPathArc);
            }
            return new Path(path);
        }
    }
}

