/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.plain;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.InterruptibleModule;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PlainModule
extends AbstractModule
implements InterruptibleModule {
    @Override
    public String getName() {
        return "plain";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("plain", Boolean.class, "plain", "success");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        Plain plain = new Plain();
        output.setReturnValue("plain", Boolean.class, plain.checkPlain(pn));
    }

    @Override
    public String getTitle() {
        return "Plain";
    }

    @Override
    public String getShortDescription() {
        return "Check if a Petri net is plain";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + ". A Petri net is plain if all arc weights are at most 1.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

