/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.analysis.petrify;

import java.io.IOException;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.petrify.PetrifyLTSSynthesize;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class PetrifySynthesizeModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "use_petrify";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("lts", TransitionSystem.class, "The LTS that should be examined", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("dead", String.class, "If the given LTS is dead", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("synthesizable", Boolean.class, "success");
        outputSpec.addReturnValue("error", String.class, new String[0]);
        outputSpec.addReturnValue("pn", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        TransitionSystem ts = input.getParameter("lts", TransitionSystem.class);
        PetrifyLTSSynthesize checkLTS = new PetrifyLTSSynthesize(ts);
        checkLTS.setSndParameter(input.getParameter("dead", String.class));
        try {
            boolean b = checkLTS.check();
            output.setReturnValue("synthesizable", Boolean.class, b);
            if (b) {
                output.setReturnValue("error", String.class, null);
                output.setReturnValue("pn", PetriNet.class, checkLTS.getPN());
            } else {
                output.setReturnValue("error", String.class, checkLTS.getError());
            }
        }
        catch (IOException ex) {
            throw new ModuleException(ex);
        }
    }

    @Override
    public String getShortDescription() {
        return "Check if Petrify can generate a Petri net from a LTS";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + "\n\nFor this module to function properly you must ensure that the Petrify executable can be found on your system. On most systems adding the directory where the executable is located to the PATH environment variable suffices to make it available to the APT system.";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.LTS};
    }
}

